/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.manager.issue.fields.AbstractDefaultCustomFieldProvider;
import com.atlassian.greenhopper.manager.issue.fields.CustomFieldContextConfigurator;
import com.atlassian.greenhopper.manager.properties.ManagedFieldPropertyDao;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlagCustomFieldProvider
extends AbstractDefaultCustomFieldProvider {
    public static final String FLAG_FIELD_NAME = "gh.issue.flaggingfield";
    public static final String FLAG_FIELD_DESC = "gh.issue.flaggingfielddesc";
    public static final String FLAG_FIELD_VALUE = "gh.issue.flaggingvalue";
    @VisibleForTesting
    static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.issue.flaggingfield").setFieldDescription("gh.issue.flaggingfielddesc").setFieldType("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes").setFieldSearcher("com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher").setIssueTypePrototypes(IssueTypePrototype.ALL).setOptionNames("gh.issue.flaggingvalue").setLockField(false).build();
    private final ManagedFieldPropertyDao managedFieldPropertyDao;
    private final CustomFieldContextConfigurator customFieldContextConfigurator;
    private final I18nFactoryService i18nFactoryService;

    @Autowired
    public FlagCustomFieldProvider(CustomFieldService customFieldService, JiraAuthenticationContext jiraAuthenticationContext, ReindexMessageManager reindexMessageManager, ClusterLockService clusterLockService, ManagedFieldPropertyDao managedFieldPropertyDao, CustomFieldContextConfigurator customFieldContextConfigurator, I18nFactoryService i18nFactoryService) {
        super(customFieldService, jiraAuthenticationContext, reindexMessageManager, clusterLockService, "Flagged", CUSTOMFIELD_METADATA);
        this.managedFieldPropertyDao = managedFieldPropertyDao;
        this.customFieldContextConfigurator = customFieldContextConfigurator;
        this.i18nFactoryService = i18nFactoryService;
    }

    public void ensureFieldHasCorrectContext() {
        CustomField customField;
        List schemes;
        if (this.doesDefaultFieldExist() && (schemes = (customField = this.getOrCreateDefaultField()).getConfigurationSchemes()).isEmpty()) {
            this.customFieldService.associateCustomFieldContext(customField, this.customFieldMetadata.getIssueTypePrototypes());
        }
    }

    @Override
    @Nullable
    protected Long getStoredCustomFieldId() {
        return this.managedFieldPropertyDao.getFlagProperty();
    }

    @Override
    protected void setStoredCustomFieldId(@Nullable Long id) {
        this.managedFieldPropertyDao.setFlagProperty(id);
    }

    @Override
    protected void afterFieldIsProduced(CustomField field) {
        super.afterFieldIsProduced(field);
        I18n2 i18n = this.i18nFactoryService.getI18n(this.jiraAuthenticationContext.getUser());
        this.customFieldContextConfigurator.ensureFieldHasCorrectContext(i18n, field, this.customFieldMetadata);
    }
}

