/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.CustomFieldContextConfigurator;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldContextConfiguratorImpl
implements CustomFieldContextConfigurator {
    private final LoggerWrapper log = LoggerWrapper.with(CustomFieldContextConfiguratorImpl.class);
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private FieldConfigSchemeManager fieldConfigSchemeManager;
    @Autowired
    private IssueTypeService issueTypeService;

    @Override
    public boolean ensureFieldHasCorrectContext(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata) {
        if (customFieldMetadata.getOptionNames().isEmpty()) {
            this.getDefaultAndRemoveRestSchemes(customField, customFieldMetadata);
        } else {
            ServiceOutcome<FieldConfigScheme> schemeCheckOutcome = this.checkFieldConfigScheme(customField, customFieldMetadata);
            if (schemeCheckOutcome.isInvalid()) {
                this.logErrors(schemeCheckOutcome);
                return false;
            }
            ServiceOutcome<Void> optionCheckOutcome = this.checkFieldConfigOptions(i18n, customField, customFieldMetadata, schemeCheckOutcome.getValue());
            if (optionCheckOutcome.isInvalid()) {
                this.logErrors(optionCheckOutcome);
                return false;
            }
        }
        return true;
    }

    private FieldConfigScheme getDefaultAndRemoveRestSchemes(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        FieldConfigScheme scheme = this.findDefaultAndRemoveRestSchemes(customField, customFieldMetadata);
        if (scheme == null) {
            scheme = this.customFieldService.associateCustomFieldContext(customField, customFieldMetadata);
            this.log.info("No default field configuration scheme was available. Created new field configuration scheme '%s'.", scheme.getName());
        }
        return scheme;
    }

    private FieldConfigScheme findDefaultAndRemoveRestSchemes(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        List schemes = customField.getConfigurationSchemes();
        Set<String> expectedIssueTypeIds = this.getIssueTypeIds(customFieldMetadata);
        FieldConfigScheme defaultScheme = null;
        for (FieldConfigScheme scheme : schemes) {
            if (scheme.isAllProjects() && expectedIssueTypeIds.equals(scheme.getConfigs().keySet())) {
                defaultScheme = scheme;
                continue;
            }
            this.fieldConfigSchemeManager.removeFieldConfigScheme(scheme.getId());
            this.log.info("Field configuration scheme '%s' is not default. Deleting '%s' field configuration scheme.", scheme.getName(), scheme.getName());
        }
        return defaultScheme;
    }

    private ServiceOutcome<FieldConfigScheme> checkFieldConfigScheme(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        List schemes = customField.getConfigurationSchemes();
        if (schemes.size() == 0) {
            FieldConfigScheme scheme = this.customFieldService.associateCustomFieldContext(customField, customFieldMetadata);
            this.log.info("No default field configuration scheme was available. Created new field configuration scheme '%s'.", scheme.getName());
            return ServiceOutcomeImpl.ok(scheme);
        }
        if (schemes.size() > 1) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "Too many configuration schemes for '%s' field", customField.getName());
        }
        FieldConfigScheme scheme = (FieldConfigScheme)schemes.get(0);
        if (!scheme.isAllProjects()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "The '%s' field configuration scheme is not marked as all projects for '%s' field", scheme.getName(), customField.getName());
        }
        Set<String> expectedIssueTypeIds = this.getIssueTypeIds(customFieldMetadata);
        if (!expectedIssueTypeIds.equals(scheme.getConfigs().keySet())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "The '%s' field configuration scheme is not associated with the appropriate issue types (%s) for '%s' field", scheme.getName(), expectedIssueTypeIds, customField.getName());
        }
        return ServiceOutcomeImpl.ok(scheme);
    }

    private Set<String> getIssueTypeIds(CustomFieldMetadata customFieldMetadata) {
        HashSet<String> issueTypesIds = new HashSet<String>();
        for (IssueTypePrototype issueTypePrototype : customFieldMetadata.getIssueTypePrototypes()) {
            issueTypesIds.add(this.issueTypeService.getIssueTypeId(issueTypePrototype));
        }
        return issueTypesIds;
    }

    private ServiceOutcome<Void> checkFieldConfigOptions(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata, FieldConfigScheme fieldConfigScheme) {
        FieldConfig fieldConfig = fieldConfigScheme.getOneAndOnlyConfig();
        if (fieldConfig == null) {
            Map configs = fieldConfigScheme.getConfigs();
            int numConfigs = configs == null ? 0 : configs.size();
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "Field '%s': Expected to have one and only one field config, but did not. Field Config Scheme [id=%d] has %d configs.", customField.getName(), fieldConfigScheme.getId(), numConfigs);
        }
        io.atlassian.fugue.Option<Options> optionsResult = CustomFieldUtil.getCustomFieldOptions(customField, fieldConfig);
        if (optionsResult.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "Field '%s': Expected to have options, but did not.", customField.getName());
        }
        Options options = (Options)optionsResult.get();
        if (options.isEmpty()) {
            this.addCustomFieldOptions(i18n, customField, customFieldMetadata, fieldConfig);
            return ServiceOutcomeImpl.ok();
        }
        List<String> optionNames = customFieldMetadata.getOptionNames();
        if (optionNames.size() != options.size()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "Field '%s': Expected to have '%d' options, but have '%d'", customField.getName(), optionNames.size(), options.size());
        }
        ErrorCollection optionErrors = new ErrorCollection();
        int n = optionNames.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.get(i);
            String optionName = optionNames.get(i);
            String optionValue = i18n.getText(optionName);
            if (optionValue.equals(option.getValue())) continue;
            optionErrors.addError("Field '%s': Option on index '%d' was '%s' but we expected to be '%s'", customField.getName(), i, option.getValue(), optionValue);
        }
        Option defaultOption = (Option)customField.getCustomFieldType().getDefaultValue(fieldConfig);
        String defaultOptionName = customFieldMetadata.getDefaultOptionName();
        String defaultOptionValue = i18n.getText(defaultOptionName);
        if (defaultOption == null || !defaultOptionValue.equals(defaultOption.getValue())) {
            optionErrors.addError("Field '%s': Option '%s' was default but we expected to be '%s'", customField.getName(), defaultOption != null ? defaultOption.getValue() : null, defaultOptionValue);
        }
        return ServiceOutcomeImpl.from(optionErrors);
    }

    private void logErrors(ServiceOutcome<?> outcome) {
        if (outcome.isValid()) {
            return;
        }
        for (ErrorCollection.ErrorItem item : outcome.getErrors().getErrors()) {
            this.log.warn(item.getMessageKey(), item.getParams());
        }
    }

    private void addCustomFieldOptions(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata, FieldConfig fieldConfig) {
        io.atlassian.fugue.Option<Options> optionsResult = CustomFieldUtil.getCustomFieldOptions(customField, fieldConfig);
        if (optionsResult.isEmpty()) {
            return;
        }
        Options options = (Options)optionsResult.get();
        if (!options.isEmpty()) {
            return;
        }
        String defaultOptionName = customFieldMetadata.getDefaultOptionName();
        for (String optionName : customFieldMetadata.getOptionNames()) {
            String translatedOption = i18n.getText(optionName);
            Option option = options.addOption(null, translatedOption);
            if (!optionName.equals(defaultOptionName)) continue;
            Class<?> customFieldTypeClass = customField.getCustomFieldType().getClass();
            if (SelectCFType.class.isAssignableFrom(customFieldTypeClass)) {
                customField.getCustomFieldType().setDefaultValue(fieldConfig, (Object)option);
                continue;
            }
            if (MultiSelectCFType.class.isAssignableFrom(customFieldTypeClass)) {
                customField.getCustomFieldType().setDefaultValue(fieldConfig, Collections.singleton(option));
                continue;
            }
            this.log.error("Attempted to assign a default value Option to a custom field whose type '%s' is unknown. Skipping...", customFieldTypeClass);
        }
        this.customFieldService.setOptionsOrderFromMetadata(customField, customFieldMetadata);
        this.log.info("Options configuration created for field '%s'", customField.getName());
    }
}

