/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.DefaultCustomFieldProvider;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.annotation.Nullable;

public abstract class AbstractDefaultCustomFieldProvider
implements DefaultCustomFieldProvider {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    protected final CustomFieldService customFieldService;
    protected final CustomFieldMetadata customFieldMetadata;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    private final ReindexMessageManager reindexMessageManager;
    private final ClusterLockService clusterLockService;
    private final String typeName;

    public AbstractDefaultCustomFieldProvider(CustomFieldService customFieldService, JiraAuthenticationContext jiraAuthenticationContext, ReindexMessageManager reindexMessageManager, ClusterLockService clusterLockService, String typeName, CustomFieldMetadata customFieldMetadata) {
        this.customFieldService = customFieldService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.reindexMessageManager = reindexMessageManager;
        this.clusterLockService = clusterLockService;
        this.typeName = typeName;
        this.customFieldMetadata = customFieldMetadata;
    }

    @Override
    public CustomField getOrCreateDefaultField() {
        CustomField customField = this.getDefaultFieldOrNull();
        if (customField == null) {
            customField = this.ensureDefaultFieldIsAvailable();
        }
        return customField;
    }

    @Override
    public boolean doesDefaultFieldExist() {
        return this.getDefaultFieldOrNull() != null;
    }

    @Nullable
    protected abstract Long getStoredCustomFieldId();

    protected abstract void setStoredCustomFieldId(@Nullable Long var1);

    private CustomField getDefaultFieldOrNull() {
        this.log.debug("Requesting the Default field for type: ", this.typeName);
        Long id = this.getStoredCustomFieldId();
        if (id != null) {
            this.log.debug("Field ID '%d' has been set -- verifying that the field still exists", id);
            CustomField customField = this.customFieldService.getCustomField(id);
            if (customField != null) {
                this.log.debug("Default field with custom field ID '%d' exists", customField.getIdAsLong());
                return customField;
            }
            this.log.debug("Field with ID '%d' did not exist", id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomField ensureDefaultFieldIsAvailable() {
        String fieldProviderName = this.getClass().getName();
        ClusterLock lock = this.clusterLockService.getLockForName(fieldProviderName);
        lock.lock();
        CustomField field = null;
        try {
            field = this.getDefaultFieldOrNull();
            if (field == null) {
                field = this.produceDefaultField();
                this.setStoredCustomFieldId(field.getIdAsLong());
                this.afterFieldIsProduced(field);
            }
        }
        finally {
            lock.unlock();
        }
        return field;
    }

    private CustomField produceDefaultField() {
        CustomField field = this.customFieldService.createCustomField(this.customFieldMetadata);
        this.log.info("Created Default field with ID '%d'", field.getIdAsLong());
        return field;
    }

    protected void afterFieldIsProduced(CustomField field) {
        this.reindexMessageManager.pushMessage(this.jiraAuthenticationContext.getUser(), field.getFieldName() + " Field Creation");
    }
}

