/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.estimatestatistic;

import com.atlassian.greenhopper.events.board.BoardEventPublisher;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticAO;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticAOMapper;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticDao;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimateStatisticManager {
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private EstimateStatisticDao estimateStatisticDao;
    @Autowired
    private EstimateStatisticAOMapper estimateStatisticAOMapper;
    @Autowired
    private BoardEventPublisher boardEventPublisher;

    public StatisticsFieldConfig getEstimateStatistic(RapidView rapidView) {
        EstimateStatisticAO estimateStatisticAO = this.estimateStatisticDao.getOne(rapidView.getId());
        if (estimateStatisticAO == null) {
            return StatisticsFieldConfig.buildNone();
        }
        return this.estimateStatisticAOMapper.toModel(estimateStatisticAO);
    }

    public ServiceOutcome<StatisticsFieldConfig> updateEstimateStatistic(RapidView rapidView, StatisticsFieldConfig estimateStatistic) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        EstimateStatisticAO updated = this.estimateStatisticDao.updateOne((RapidViewAO)rapidViewAO.getValue(), estimateStatistic);
        this.boardEventPublisher.publishBoardConfigurationChangedEvent(rapidView);
        return ServiceOutcomeImpl.ok(this.estimateStatisticAOMapper.toModel(updated));
    }

    public ServiceOutcome<StatisticsFieldConfig> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        StatisticsFieldConfig estimateStatistic = this.getEstimateStatistic(sourceRapidView);
        return this.updateEstimateStatistic(targetRapidView, estimateStatistic);
    }

    public void deleteEstimateStatistics(RapidViewAO rapidViewAO) {
        this.estimateStatisticDao.deleteForParent(rapidViewAO);
    }
}

