/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.estimatestatistic;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticAO;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticAOListMapper;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticAOMapper;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.ObjectNotFoundException;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimateStatisticDao
extends GenericActiveObjectsDao<Long, EstimateStatisticAO>
implements RelatedEntityDao<Long, RapidViewAO, EstimateStatisticAO, StatisticsFieldConfig> {
    @Autowired
    private EstimateStatisticAOMapper estimateStatisticAOMapper;

    @Nonnull
    public EstimateStatisticAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public EstimateStatisticAO[] getForParent(Long primaryKey) {
        return (EstimateStatisticAO[])this.ao.find(EstimateStatisticAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    public EstimateStatisticAO getOne(Long rapidViewId) {
        EstimateStatisticAO[] estimateStatisticAOs = this.getForParent(rapidViewId);
        if (estimateStatisticAOs.length == 0) {
            return null;
        }
        return estimateStatisticAOs[0];
    }

    @Override
    @Nonnull
    public List<EstimateStatisticAO> updateForParent(RapidViewAO rapidViewAO, List<StatisticsFieldConfig> models) {
        return AOUtil.setListValues(this.ao, new EstimateStatisticAOListMapper(rapidViewAO, this.estimateStatisticAOMapper), models);
    }

    @Nonnull
    public EstimateStatisticAO updateOne(RapidViewAO rapidViewAO, StatisticsFieldConfig estimateStatistic) {
        List<EstimateStatisticAO> estimateStatistics = AOUtil.setListValues(this.ao, new EstimateStatisticAOListMapper(rapidViewAO, this.estimateStatisticAOMapper), Collections.singletonList(estimateStatistic));
        if (estimateStatistics.isEmpty()) {
            ObjectNotFoundException e = new ObjectNotFoundException(String.format("After updating estimation statistic config '%s' we are left with no EstimateStatisticAO records for rapid view id=%d", ToStringBuilder.reflectionToString((Object)estimateStatistic), rapidViewAO.getId()));
            this.log.exception(e);
            throw e;
        }
        return estimateStatistics.get(0);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        EstimateStatisticAO[] estimateStatisticAOs = rapidViewAO.getEstimateStatistics();
        if (estimateStatisticAOs != null) {
            this.delete(estimateStatisticAOs);
        }
    }
}

