/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.detailview;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAO;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAOListMapper;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAOMapper;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldDao;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.Entity;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailViewFieldManagerImpl
implements DetailViewFieldManager {
    @Autowired
    private DetailViewFieldAOMapper detailViewFieldAOMapper;
    @Autowired
    private DetailViewFieldDao detailViewFieldDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, ImmutableList<DetailViewField>> detailViewFieldCache;

    @PostConstruct
    public void init() {
        this.detailViewFieldCache = this.cacheFactoryManager.create().getCache(DetailViewFieldManagerImpl.class.getName() + ".detailViewFieldCache", new DetailViewFieldCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public ServiceOutcome<DetailViewField> get(RapidView rapidView, long detailViewFieldId) {
        ServiceOutcome<List<DetailViewField>> detailViewFields = this.getAll(rapidView);
        if (!detailViewFields.isValid()) {
            return ServiceOutcomeImpl.error(detailViewFields);
        }
        for (DetailViewField detailViewField : detailViewFields.getValue()) {
            if (!detailViewField.getId().equals(detailViewFieldId)) continue;
            return ServiceOutcomeImpl.ok(detailViewField);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.detailviewfield.id.invalid", detailViewFieldId);
    }

    @Override
    public ServiceOutcome<List<DetailViewField>> getAll(RapidView rapidView) {
        ImmutableList<DetailViewField> detailViewFields = this.detailViewFieldCache.get(rapidView.getId());
        return ServiceOutcomeImpl.ok(new ArrayList<DetailViewField>((Collection<DetailViewField>)detailViewFields));
    }

    @Override
    public ServiceOutcome<DetailViewField> add(RapidView rapidView, DetailViewField detailViewField) {
        List<DetailViewField> detailViewFields = this.getAllFromDao(rapidView.getId());
        detailViewFields.add(0, detailViewField);
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<DetailViewFieldAO> updatedDetailViewFields = this.detailViewFieldDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), detailViewFields);
        this.detailViewFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.detailViewFieldAOMapper.toModel(updatedDetailViewFields.get(0)));
    }

    @Override
    public ServiceOutcome<DetailViewField> update(RapidView rapidView, DetailViewField detailViewField) {
        ServiceOutcome<DetailViewField> existingDetailViewField = this.get(rapidView, detailViewField.getId());
        if (!existingDetailViewField.isValid()) {
            return ServiceOutcomeImpl.error(existingDetailViewField);
        }
        ServiceOutcome<DetailViewFieldAO> updatedDetailViewField = this.detailViewFieldDao.update(detailViewField);
        if (!updatedDetailViewField.isValid()) {
            return ServiceOutcomeImpl.error(updatedDetailViewField);
        }
        this.detailViewFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.detailViewFieldAOMapper.toModel(updatedDetailViewField.getValue()));
    }

    @Override
    public ServiceOutcome<List<DetailViewField>> set(RapidView rapidView, List<DetailViewField> detailViewFields) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<DetailViewFieldAO> detailViewFieldAOs = this.detailViewFieldDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), detailViewFields);
        List storedDetailViewFields = this.detailViewFieldAOMapper.toModel(detailViewFieldAOs);
        this.detailViewFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(storedDetailViewFields);
    }

    @Override
    public ServiceOutcome<Void> delete(RapidView rapidView, long detailViewFieldId) {
        List<DetailViewField> detailViewFields = this.getAllFromDao(rapidView.getId());
        DetailViewField existingDetailViewField = this.findById(detailViewFields, detailViewFieldId);
        if (existingDetailViewField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.detailviewfield.id.invalid", detailViewFieldId);
        }
        detailViewFields.remove(existingDetailViewField);
        ServiceOutcome<List<DetailViewField>> outcome = this.set(rapidView, detailViewFields);
        if (!outcome.isValid()) {
            ServiceOutcomeImpl.error(outcome);
        }
        this.detailViewFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> moveAfter(RapidView rapidView, long detailViewFieldId, Long moveAfterDetailViewFieldId) {
        ServiceOutcome<List<DetailViewField>> detailViewFieldsOutcome = this.getAll(rapidView);
        if (!detailViewFieldsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(detailViewFieldsOutcome);
        }
        List<DetailViewField> detailViewFields = detailViewFieldsOutcome.getValue();
        DetailViewField detailViewField = this.findById(detailViewFields, detailViewFieldId);
        if (detailViewField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.detailviewfield.id.invalid", detailViewFieldId);
        }
        DetailViewField moveAfterDetailViewField = null;
        if (moveAfterDetailViewFieldId != null && (moveAfterDetailViewField = this.findById(detailViewFields, moveAfterDetailViewFieldId)) == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.detailviewfield.id.invalid", moveAfterDetailViewFieldId);
        }
        detailViewFields.remove(detailViewField);
        int insertIndex = moveAfterDetailViewField != null ? detailViewFields.indexOf(moveAfterDetailViewField) + 1 : 0;
        detailViewFields.add(insertIndex, detailViewField);
        ServiceOutcome<List<DetailViewField>> result = this.set(rapidView, detailViewFields);
        if (!result.isValid()) {
            return ServiceOutcomeImpl.error(result);
        }
        this.detailViewFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<List<DetailViewField>> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        ServiceOutcome<List<DetailViewField>> all = this.getAll(sourceRapidView);
        if (!all.isValid()) {
            return ServiceOutcomeImpl.error(all);
        }
        ArrayList<DetailViewField> copiedDetailViewFields = new ArrayList<DetailViewField>();
        for (DetailViewField sourceDetailViewField : all.getValue()) {
            DetailViewField copiedDetailViewField = DetailViewField.builder(sourceDetailViewField).id(null).build();
            copiedDetailViewFields.add(copiedDetailViewField);
        }
        return this.set(targetRapidView, copiedDetailViewFields);
    }

    @Override
    public void invalidate(RapidView view) {
        this.detailViewFieldCache.remove(view.getId());
    }

    @Override
    public void flushCache() {
        this.detailViewFieldCache.removeAll();
    }

    private List<DetailViewField> getAllFromDao(Long rapidViewId) {
        Entity[] detailViewFieldAOs = this.detailViewFieldDao.getForParent(rapidViewId);
        DetailViewFieldAOListMapper aoListMapper = new DetailViewFieldAOListMapper(null, this.detailViewFieldAOMapper);
        return aoListMapper.fromAO(detailViewFieldAOs);
    }

    private DetailViewField findById(List<DetailViewField> detailViewFields, long detailViewFieldId) {
        for (DetailViewField detailViewField : detailViewFields) {
            if (detailViewField.getId() != detailViewFieldId) continue;
            return detailViewField;
        }
        return null;
    }

    private class DetailViewFieldCacheLoader
    implements CacheLoader<Long, ImmutableList<DetailViewField>> {
        private DetailViewFieldCacheLoader() {
        }

        @Override
        public ImmutableList<DetailViewField> load(@Nonnull Long rapidViewId) {
            List mutableList = DetailViewFieldManagerImpl.this.getAllFromDao(rapidViewId);
            return ImmutableList.copyOf((Collection)mutableList);
        }
    }
}

