/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.detailview;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAO;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAOListMapper;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldAOMapper;
import com.atlassian.greenhopper.model.rapid.detailview.DetailViewField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailViewFieldDao
extends GenericActiveObjectsDao<Long, DetailViewFieldAO>
implements RelatedEntityDao<Long, RapidViewAO, DetailViewFieldAO, DetailViewField> {
    @Autowired
    private DetailViewFieldAOMapper detailViewFieldAOMapper;

    public DetailViewFieldAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public DetailViewFieldAO[] getForParent(Long primaryKey) {
        return (DetailViewFieldAO[])this.ao.find(DetailViewFieldAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    @Override
    public List<DetailViewFieldAO> updateForParent(RapidViewAO rapidViewAO, List<DetailViewField> models) {
        return AOUtil.setListValues(this.ao, new DetailViewFieldAOListMapper(rapidViewAO, this.detailViewFieldAOMapper), models);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        DetailViewFieldAO[] detailViewFieldAOs = rapidViewAO.getDetailViewFields();
        if (detailViewFieldAOs != null) {
            this.delete(detailViewFieldAOs);
        }
    }

    public ServiceOutcome<DetailViewFieldAO> update(DetailViewField detailViewField) {
        DetailViewFieldAO detailViewFieldAO = (DetailViewFieldAO)this.ao.get(DetailViewFieldAO.class, (Object)detailViewField.getId());
        if (detailViewFieldAO == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "DetailViewField with id {0} not found", detailViewField.getId());
        }
        this.detailViewFieldAOMapper.update(detailViewField, detailViewFieldAO);
        detailViewFieldAO.save();
        return ServiceOutcomeImpl.ok(detailViewFieldAO);
    }
}

