/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.color;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.color.CardColorAO;
import com.atlassian.greenhopper.manager.color.CardColorAOMapper;
import com.atlassian.greenhopper.manager.color.CardColorDao;
import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.Positionable;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorManagerImpl
implements CardColorManager {
    @Autowired
    private CardColorAOMapper cardColorAOMapper;
    @Autowired
    private CardColorDao cardColorDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, ImmutableList<CardColor>> cardColorCache;

    @PostConstruct
    public void init() {
        this.cardColorCache = this.cacheFactoryManager.create().getCache(CardColorManagerImpl.class.getName() + ".cardColorCache", new CardColorCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public ServiceOutcome<List<CardColor>> getAll(RapidView rapidView) {
        ImmutableList<CardColor> cardColors = this.cardColorCache.get(rapidView.getId());
        return ServiceOutcomeImpl.ok(new ArrayList<CardColor>((Collection<CardColor>)cardColors));
    }

    @Override
    public ServiceOutcome<CardColor> get(RapidView rapidView, long cardColorId) {
        ServiceOutcome<List<CardColor>> cardColors = this.getAll(rapidView);
        if (!cardColors.isValid()) {
            return ServiceOutcomeImpl.error(cardColors);
        }
        for (CardColor cardColor : cardColors.getValue()) {
            if (!cardColor.getId().equals(cardColorId)) continue;
            return ServiceOutcomeImpl.ok(cardColor);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.cardcolor.id.invalid", cardColorId);
    }

    @Override
    public ServiceOutcome<CardColor> add(RapidView rapidView, CardColor cardColor) {
        List<CardColor> cardColors = this.fromAO(this.cardColorDao.getForParent(rapidView.getId()));
        cardColors.add(0, cardColor);
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<CardColorAO> updatedCardColors = this.cardColorDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), cardColors);
        this.cardColorCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.cardColorAOMapper.toModel(updatedCardColors.get(0)));
    }

    @Override
    public ServiceOutcome<CardColor> update(RapidView rapidView, CardColor cardColor) {
        ServiceOutcome<CardColor> existingCardColor = this.get(rapidView, cardColor.getId());
        if (!existingCardColor.isValid()) {
            return ServiceOutcomeImpl.error(existingCardColor);
        }
        ServiceOutcome<CardColorAO> updatedCardColor = this.cardColorDao.update(cardColor);
        if (!updatedCardColor.isValid()) {
            return ServiceOutcomeImpl.error(updatedCardColor);
        }
        this.cardColorCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(this.cardColorAOMapper.toModel(updatedCardColor.getValue()));
    }

    @Override
    public ServiceOutcome<List<CardColor>> set(RapidView rapidView, List<CardColor> cardColors) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<CardColorAO> cardColorAOs = this.cardColorDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), cardColors);
        List<CardColor> storedCardColors = this.cardColorAOMapper.toModels(cardColorAOs);
        this.cardColorCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok(storedCardColors);
    }

    @Override
    public ServiceOutcome<Void> delete(RapidView rapidView, long cardColorId) {
        List<CardColor> cardColors = this.fromAO(this.cardColorDao.getForParent(rapidView.getId()));
        CardColor existingCardColor = this.findById(cardColors, cardColorId);
        if (existingCardColor == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.cardcolor.id.invalid", cardColorId);
        }
        cardColors.remove(existingCardColor);
        ServiceOutcome<List<CardColor>> outcome = this.set(rapidView, cardColors);
        if (!outcome.isValid()) {
            ServiceOutcomeImpl.error(outcome);
        }
        this.cardColorCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> moveAfter(RapidView rapidView, long cardColorId, Long moveToCardColorId) {
        ServiceOutcome<List<CardColor>> cardColorsOutcome = this.getAll(rapidView);
        if (!cardColorsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(cardColorsOutcome);
        }
        List<CardColor> cardColors = cardColorsOutcome.getValue();
        CardColor cardColor = this.findById(cardColors, cardColorId);
        if (cardColor == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.cardcolor.id.invalid", cardColorId);
        }
        CardColor moveToCardColor = null;
        if (moveToCardColorId != null && (moveToCardColor = this.findById(cardColors, moveToCardColorId)) == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.cardcolor.id.invalid", moveToCardColor);
        }
        cardColors.remove(cardColor);
        int insertIndex = moveToCardColor != null ? cardColors.indexOf(moveToCardColor) + 1 : 0;
        cardColors.add(insertIndex, cardColor);
        ServiceOutcome<List<CardColor>> result = this.set(rapidView, cardColors);
        if (!result.isValid()) {
            return ServiceOutcomeImpl.error(result);
        }
        this.cardColorCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<List<CardColor>> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        ServiceOutcome<List<CardColor>> all = this.getAll(sourceRapidView);
        if (!all.isValid()) {
            return ServiceOutcomeImpl.error(all);
        }
        ArrayList<CardColor> copiedCardColors = new ArrayList<CardColor>();
        for (CardColor sourceCardColor : all.getValue()) {
            CardColor copiedCardColor = CardColor.builder(sourceCardColor).id(null).build();
            copiedCardColors.add(copiedCardColor);
        }
        return this.set(targetRapidView, copiedCardColors);
    }

    @Override
    public void invalidate(RapidView view) {
        this.cardColorCache.remove(view.getId());
    }

    @Override
    public void flushCache() {
        this.cardColorCache.removeAll();
    }

    private List<CardColor> fromAO(CardColorAO[] cardColorAOs) {
        AOUtil.sortPositionableArray((Positionable[])cardColorAOs);
        ArrayList<CardColor> cardColors = new ArrayList<CardColor>();
        for (CardColorAO cardColorAO : cardColorAOs) {
            cardColors.add(this.cardColorAOMapper.toModel(cardColorAO));
        }
        return cardColors;
    }

    private CardColor findById(List<CardColor> cardColors, long cardColorId) {
        for (CardColor cardColor : cardColors) {
            if (cardColor.getId() != cardColorId) continue;
            return cardColor;
        }
        return null;
    }

    private class CardColorCacheLoader
    implements CacheLoader<Long, ImmutableList<CardColor>> {
        private CardColorCacheLoader() {
        }

        @Override
        public ImmutableList<CardColor> load(@Nonnull Long rapidViewId) {
            CardColorAO[] cardColorAOs = CardColorManagerImpl.this.cardColorDao.getForParent(rapidViewId);
            List mutableList = CardColorManagerImpl.this.fromAO(cardColorAOs);
            return ImmutableList.copyOf((Collection)mutableList);
        }
    }
}

