/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.color;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.color.CardColorAO;
import com.atlassian.greenhopper.manager.color.CardColorAOListMapper;
import com.atlassian.greenhopper.manager.color.CardColorAOMapper;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorDao
extends GenericActiveObjectsDao<Long, CardColorAO>
implements RelatedEntityDao<Long, RapidViewAO, CardColorAO, CardColor> {
    @Autowired
    CardColorAOMapper cardColorAOMapper;

    @Nonnull
    public CardColorAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public CardColorAO[] getForParent(Long primaryKey) {
        return (CardColorAO[])this.ao.find(CardColorAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    @Override
    @Nonnull
    public List<CardColorAO> updateForParent(RapidViewAO rapidViewAO, List<CardColor> models) {
        return AOUtil.setListValues(this.ao, new CardColorAOListMapper(rapidViewAO, this.cardColorAOMapper), models);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        CardColorAO[] cardColorAOs = rapidViewAO.getCardColors();
        if (cardColorAOs != null) {
            this.delete(cardColorAOs);
        }
    }

    public ServiceOutcome<CardColorAO> update(CardColor cardColor) {
        CardColorAO cardColorAO = (CardColorAO)this.ao.get(CardColorAO.class, (Object)cardColor.getId());
        if (cardColorAO == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "CardColor with id {0} not found", cardColor.getId());
        }
        this.cardColorAOMapper.update(cardColor, cardColorAO);
        cardColorAO.save();
        return ServiceOutcomeImpl.ok(cardColorAO);
    }
}

