/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.color;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.manager.color.CardColorAO;
import com.atlassian.greenhopper.model.rapid.CardColor;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardColorAOMapper
implements RelatedAOMapper<RapidViewAO, CardColorAO, CardColor> {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    CardColorPalette cardColorPalette;

    @Override
    @Nonnull
    public Map<String, Object> toAO(CardColor cardColor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("STRATEGY", cardColor.getStrategy().getId());
        map.put("COLOR", ColorUtils.colorToHex(cardColor.getColor()));
        map.put("VAL", cardColor.getValue());
        map.put("POS", cardColor.getPosition());
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, CardColor cardColor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(cardColor));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public CardColor toModel(CardColorAO cardColorAO) {
        String cardColorStrategyId = cardColorAO.getStrategy();
        CardColorStrategy cardColorStrategy = CardColorStrategy.lookup(cardColorStrategyId);
        if (cardColorStrategy == null) {
            this.log.error("Card color id=%d has unknown strategy '%s' -- setting to 'issuetype'", cardColorAO.getId(), cardColorStrategyId);
            cardColorStrategy = CardColorStrategy.ISSUE_TYPE;
        }
        Color color = ColorUtils.hexToColor(cardColorAO.getColor(), this.cardColorPalette.getFallback());
        return CardColor.builder().id(cardColorAO.getId()).strategy(cardColorStrategy).color(color).value(StringUtils.defaultString((String)cardColorAO.getVal())).position(cardColorAO.getPos()).build();
    }

    @Override
    public void update(CardColor source, CardColorAO target) {
        target.setStrategy(source.getStrategy().getId());
        target.setColor(ColorUtils.colorToHex(source.getColor()));
        target.setVal(source.getValue());
    }

    public List<CardColor> toModels(Iterable<CardColorAO> cardColorAos) {
        ArrayList<CardColor> colors = new ArrayList<CardColor>();
        for (CardColorAO ao : cardColorAos) {
            colors.add(this.toModel(ao));
        }
        return colors;
    }
}

