/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.cardlayout;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAO;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAOListMapper;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAOMapper;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldDao;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutManager;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.Entity;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutManagerImpl
implements CardLayoutManager {
    @Autowired
    private CardLayoutFieldDao cardLayoutFieldDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    private Cache<Long, ImmutableList<CardLayoutField>> cardLayoutFieldCache;
    private CardLayoutFieldAOMapper cardLayoutFieldAOMapper;

    @Autowired
    @VisibleForTesting
    void setCardLayoutFieldAOMapper(CardLayoutFieldAOMapper cardLayoutFieldAOMapper) {
        this.cardLayoutFieldAOMapper = cardLayoutFieldAOMapper;
    }

    @PostConstruct
    public void init() {
        this.cardLayoutFieldCache = this.cacheFactoryManager.create().getCache(CardLayoutManagerImpl.class.getName() + ".cardLayoutCache", new CardLayoutCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public ServiceOutcome<List<CardLayoutField>> getAll(@Nonnull RapidView rapidView) {
        ImmutableList<CardLayoutField> cardLayoutFields = this.cardLayoutFieldCache.get(rapidView.getId());
        return ServiceOutcomeImpl.ok(Lists.newArrayList(cardLayoutFields));
    }

    @Override
    public ServiceOutcome<CardLayoutField> add(RapidView rapidView, CardLayoutField cardLayoutFieldToAdd) {
        List<CardLayoutField> cardLayoutFields = this.getAllFromDao(rapidView.getId());
        cardLayoutFields.add(0, cardLayoutFieldToAdd);
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        List<CardLayoutFieldAO> updatedCardLayoutFields = this.cardLayoutFieldDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), cardLayoutFields);
        this.cardLayoutFieldCache.remove(rapidView.getId());
        CardLayoutField newCardLayoutField = (CardLayoutField)Iterables.find((Iterable)((Iterable)this.cardLayoutFieldCache.get(rapidView.getId())), cardLayoutField -> cardLayoutField.getMode().equals((Object)cardLayoutFieldToAdd.getMode()) && cardLayoutField.getFieldId().equals(cardLayoutFieldToAdd.getFieldId()));
        return ServiceOutcomeImpl.ok(newCardLayoutField);
    }

    @Override
    public ServiceOutcome<Void> delete(RapidView rapidView, long cardLayoutFieldId) {
        List<CardLayoutField> cardLayoutFields = this.getAllFromDao(rapidView.getId());
        CardLayoutField existingCardLayoutField = this.findById(cardLayoutFields, cardLayoutFieldId);
        if (existingCardLayoutField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.cardlayoutfield.id.invalid", cardLayoutFieldId);
        }
        cardLayoutFields.remove(existingCardLayoutField);
        ServiceOutcome<List<CardLayoutField>> outcome = this.set(rapidView, cardLayoutFields);
        if (!outcome.isValid()) {
            ServiceOutcomeImpl.error(outcome);
        }
        this.cardLayoutFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> moveAfter(RapidView rapidView, long cardLayoutFieldId, Option<Long> optionalFieldIdToMoveAfter) {
        ServiceOutcome<List<CardLayoutField>> cardLayoutFieldsOutcome = this.getAll(rapidView);
        if (!cardLayoutFieldsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(cardLayoutFieldsOutcome);
        }
        List<CardLayoutField> cardLayoutFields = cardLayoutFieldsOutcome.getValue();
        CardLayoutField cardLayoutField = this.findById(cardLayoutFields, cardLayoutFieldId);
        if (cardLayoutField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.cardlayoutfield.id.invalid", cardLayoutFieldId);
        }
        CardLayoutField moveAfterCardLayoutField = null;
        if (!optionalFieldIdToMoveAfter.isEmpty() && (moveAfterCardLayoutField = this.findById(cardLayoutFields, (Long)optionalFieldIdToMoveAfter.get())) == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.view.error.cardlayoutfield.id.invalid", optionalFieldIdToMoveAfter.get());
        }
        cardLayoutFields.remove(cardLayoutField);
        int insertIndex = moveAfterCardLayoutField != null ? cardLayoutFields.indexOf(moveAfterCardLayoutField) + 1 : 0;
        cardLayoutFields.add(insertIndex, cardLayoutField);
        ServiceOutcome<List<CardLayoutField>> result = this.set(rapidView, cardLayoutFields);
        if (!result.isValid()) {
            return ServiceOutcomeImpl.error(result);
        }
        this.cardLayoutFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<List<CardLayoutField>> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        List<CardLayoutField> cardLayoutFields = this.getAllFromDao(sourceRapidView.getId());
        ArrayList<CardLayoutField> copiedCardLayoutFields = new ArrayList<CardLayoutField>();
        for (CardLayoutField cardLayoutField : cardLayoutFields) {
            CardLayoutField copiedCardLayoutField = CardLayoutField.builder(cardLayoutField).withNewId().build();
            copiedCardLayoutFields.add(copiedCardLayoutField);
        }
        return this.set(targetRapidView, copiedCardLayoutFields);
    }

    @Override
    public void invalidate(RapidView view) {
        this.cardLayoutFieldCache.remove(view.getId());
    }

    @Override
    public void flushCache() {
        this.cardLayoutFieldCache.removeAll();
    }

    private ServiceOutcome<List<CardLayoutField>> set(RapidView rapidView, List<CardLayoutField> cardLayoutFields) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        this.cardLayoutFieldDao.updateForParent((RapidViewAO)rapidViewAO.getValue(), cardLayoutFields);
        this.cardLayoutFieldCache.remove(rapidView.getId());
        return ServiceOutcomeImpl.ok((List)this.cardLayoutFieldCache.get(rapidView.getId()));
    }

    private List<CardLayoutField> getAllFromDao(Long rapidViewId) {
        Entity[] cardLayoutFieldAOs = this.cardLayoutFieldDao.getForParent(rapidViewId);
        CardLayoutFieldAOListMapper aoListMapper = new CardLayoutFieldAOListMapper(null, this.cardLayoutFieldAOMapper);
        return aoListMapper.fromAO(cardLayoutFieldAOs);
    }

    private CardLayoutField findById(List<CardLayoutField> cardLayoutFields, long cardLayoutFieldId) {
        for (CardLayoutField cardLayoutField : cardLayoutFields) {
            if (cardLayoutField.getId() != cardLayoutFieldId) continue;
            return cardLayoutField;
        }
        return null;
    }

    private class CardLayoutCacheLoader
    implements CacheLoader<Long, ImmutableList<CardLayoutField>> {
        private CardLayoutCacheLoader() {
        }

        @Override
        public ImmutableList<CardLayoutField> load(@Nonnull Long rapidViewId) {
            List mutableList = CardLayoutManagerImpl.this.getAllFromDao(rapidViewId);
            return ImmutableList.copyOf((Collection)mutableList);
        }
    }
}

