/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.cardlayout;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAO;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAOListMapper;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAOMapper;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutFieldDao
extends GenericActiveObjectsDao<Long, CardLayoutFieldAO>
implements RelatedEntityDao<Long, RapidViewAO, CardLayoutFieldAO, CardLayoutField> {
    @Autowired
    private CardLayoutFieldAOMapper cardLayoutFieldAOMapper;

    public CardLayoutFieldAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public CardLayoutFieldAO[] getForParent(Long primaryKey) {
        return (CardLayoutFieldAO[])this.ao.find(CardLayoutFieldAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    @Override
    public List<CardLayoutFieldAO> updateForParent(RapidViewAO rapidViewAO, List<CardLayoutField> models) {
        return AOUtil.setListValues(this.ao, new CardLayoutFieldAOListMapper(rapidViewAO, this.cardLayoutFieldAOMapper), models);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        CardLayoutFieldAO[] cardLayoutFieldAOs = rapidViewAO.getCardLayouts();
        if (cardLayoutFieldAOs != null) {
            this.delete(cardLayoutFieldAOs);
        }
    }

    public ServiceOutcome<CardLayoutFieldAO> update(CardLayoutField cardLayoutField) {
        CardLayoutFieldAO cardLayoutFieldAO = (CardLayoutFieldAO)this.ao.get(CardLayoutFieldAO.class, (Object)cardLayoutField.getId());
        if (cardLayoutFieldAO == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "CardLayoutField with id {0} not found", cardLayoutField.getId());
        }
        this.cardLayoutFieldAOMapper.update(cardLayoutField, cardLayoutFieldAO);
        cardLayoutFieldAO.save();
        return ServiceOutcomeImpl.ok(cardLayoutFieldAO);
    }
}

