/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.cardlayout;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldAO;
import com.atlassian.greenhopper.model.rapid.CardLayoutField;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class CardLayoutFieldAOMapper
extends AbstractAOMapper<CardLayoutFieldAO, CardLayoutField>
implements RelatedAOMapper<RapidViewAO, CardLayoutFieldAO, CardLayoutField> {
    @Override
    public Map<String, Object> toAO(RapidViewAO parent, CardLayoutField cardLayoutField) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(cardLayoutField));
        map.put("RAPID_VIEW_ID", parent);
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(CardLayoutField cardLayoutField) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FIELD_ID", cardLayoutField.getFieldId());
        map.put("POS", cardLayoutField.getPosition());
        map.put("MODE_NAME", cardLayoutField.getMode().getModeName());
        return map;
    }

    @Override
    @Nonnull
    public CardLayoutField toModel(CardLayoutFieldAO record) {
        return CardLayoutField.builder().id(record.getId()).fieldId(record.getFieldId()).position(record.getPos()).mode(CardLayoutField.Mode.fromModeName(record.getModeName())).build();
    }

    @Override
    public void update(CardLayoutField source, CardLayoutFieldAO target) {
        target.setFieldId(source.getFieldId());
        target.setModeName(source.getMode().getModeName());
        target.setPos(source.getPosition());
    }
}

