/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.audit;

import com.atlassian.greenhopper.manager.audit.AuditEntryAO;
import com.atlassian.greenhopper.manager.audit.AuditEntryAOMapper;
import com.atlassian.greenhopper.manager.audit.AuditEntryDao;
import com.atlassian.greenhopper.manager.audit.AuditEntryManager;
import com.atlassian.greenhopper.model.rapid.AuditEntry;
import com.atlassian.greenhopper.schema.querydsl.current.QAuditEntry;
import com.atlassian.pocketknife.api.querydsl.QueryFactory;
import com.atlassian.pocketknife.api.querydsl.SchemaProvider;
import com.google.common.collect.Lists;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditEntryManagerImpl
implements AuditEntryManager {
    @Autowired
    private AuditEntryDao auditEntryDao;
    @Autowired
    private AuditEntryAOMapper auditEntryAOMapper;
    @Autowired
    private QueryFactory queryFactory;
    @Autowired
    private SchemaProvider schemaProvider;

    @Override
    public AuditEntry save(AuditEntry entry) {
        AuditEntryAO entryAO = (AuditEntryAO)this.auditEntryDao.create(this.auditEntryAOMapper.toAO(entry));
        this.auditEntryDao.flushAll();
        return this.auditEntryAOMapper.toModel(entryAO);
    }

    @Override
    public List<AuditEntry> list() {
        AuditEntryAO[] entryAOs = this.auditEntryDao.list();
        return this.convertEntryArrayToList(entryAOs);
    }

    @Override
    public List<AuditEntry> getByEntityIdEntityClassAndCategory(Long entityId, String entityClass, String category) {
        AuditEntryAO[] entryAOs = this.auditEntryDao.getByEntityIdEntityClassAndCategory(entityId, entityClass, category);
        return this.convertEntryArrayToList(entryAOs);
    }

    @Override
    public long changeUserKey(@Nonnull String oldKey, @Nonnull String newKey) {
        QAuditEntry AUDIT_ENTRY = QAuditEntry.withSchema(this.schemaProvider);
        return (Long)this.queryFactory.update(AUDIT_ENTRY, update -> ((SQLUpdateClause)update.set((Path)AUDIT_ENTRY.USER, newKey)).where((Predicate)AUDIT_ENTRY.USER.eq(oldKey)).execute());
    }

    @Override
    public long countByUserKey(@Nonnull String key) {
        return this.auditEntryDao.countByUserKey(key);
    }

    private List<AuditEntry> convertEntryArrayToList(AuditEntryAO[] entryAOs) {
        ArrayList entries = Lists.newArrayList();
        for (AuditEntryAO ao : entryAOs) {
            entries.add(this.auditEntryAOMapper.toModel(ao));
        }
        return entries;
    }
}

