/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.audit;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.audit.AuditEntryAO;
import com.atlassian.greenhopper.model.rapid.AuditEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class AuditEntryAOMapper
extends AbstractAOMapper<AuditEntryAO, AuditEntry> {
    @Override
    @Nonnull
    public Map<String, Object> toAO(AuditEntry model) {
        HashMap map = Maps.newHashMap();
        map.put("USER", model.getUser());
        map.put("TIME", model.getTime().getMillis());
        map.put("ENTITY_ID", model.getEntityId());
        map.put("ENTITY_CLASS", model.getEntityType());
        map.put("CATEGORY", model.getCategory());
        map.put("DATA", model.getData());
        return map;
    }

    @Override
    @Nonnull
    public AuditEntry toModel(AuditEntryAO record) {
        return AuditEntry.builder().id(record.getId()).user(record.getUser()).time(new DateTime((Object)record.getTime())).entityId(record.getEntityId()).entityType(record.getEntityClass()).category(record.getCategory()).data(record.getData()).build();
    }

    @Override
    public void update(AuditEntry source, AuditEntryAO target) {
        target.setUser(source.getUser());
        target.setTime(source.getTime().getMillis());
        target.setEntityId(source.getEntityId());
        target.setEntityClass(source.getEntityType());
        target.setCategory(source.getCategory());
        target.setData(source.getData().toString());
    }
}

