/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager;

import com.atlassian.greenhopper.manager.AOListMapper;
import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.Entity;
import com.atlassian.greenhopper.service.rapid.view.Positionable;
import com.atlassian.jira.entity.WithId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractRelatedAOListMapper<P, T extends Entity, U extends WithId>
implements AOListMapper<T, U> {
    protected final P parentAO;
    protected final RelatedAOMapper<P, T, U> mapper;

    protected AbstractRelatedAOListMapper(P parentAO, RelatedAOMapper<P, T, U> mapper) {
        this.parentAO = parentAO;
        this.mapper = mapper;
    }

    @Override
    public void addCreateValues(U model, Map<String, Object> params) {
        params.putAll(this.mapper.toAO(this.parentAO, model));
    }

    @Override
    public void setValues(T recordAO, U model) {
        this.mapper.update(model, recordAO);
    }

    @Override
    public T findExisting(T[] recordAOs, U model) {
        if (model.getId() == null) {
            return null;
        }
        for (T record : recordAOs) {
            if (record.getId() != model.getId().longValue()) continue;
            return record;
        }
        return null;
    }

    @Override
    public List<U> fromAO(T[] ts) {
        if (Positionable.class.isAssignableFrom(this.getActiveObjectClass())) {
            AOUtil.sortPositionableArray((Positionable[])((Positionable[])ts));
        }
        ArrayList transformed = new ArrayList();
        for (T t : ts) {
            transformed.add(this.mapper.toModel(t));
        }
        return transformed;
    }

    @Override
    public abstract Class<T> getActiveObjectClass();

    @Override
    public abstract void postCreateUpdate(T var1, U var2);

    @Override
    public abstract void preDelete(T var1);

    @Override
    public abstract T[] getExisting();
}

