/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.license;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.greenhopper.license.SoftwareAuthorizationService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SoftwareAuthorizationServiceImpl
implements SoftwareAuthorizationService {
    private static final ApplicationKey SOFTWARE_KEY = ApplicationKey.valueOf((String)"jira-software");
    @Autowired
    private ApplicationAuthorizationService applicationAuthorizationService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    private LazyReference<I18n2> i18n2 = new LazyReference<I18n2>(){

        @Override
        protected I18n2 create() throws Exception {
            return SoftwareAuthorizationServiceImpl.this.i18nFactoryService.getI18n();
        }
    };

    @Override
    public boolean canUseApplication(@Nullable ApplicationUser user) {
        return this.applicationAuthorizationService.canUseApplication(user, SOFTWARE_KEY);
    }

    @Override
    public void verifySoftwareLicense() throws LicenseException {
        Collection<ApplicationAccess.AccessError> accessErrors = this.getSoftwareLicensingAccessErrors();
        Option accessError = Iterables.first(accessErrors);
        if (accessError.isDefined()) {
            switch ((ApplicationAccess.AccessError)accessError.get()) {
                case UNLICENSED: {
                    throw new LicenseException(this.i18n2.get().getText("jira.software.license.not.licensed"));
                }
                case EXPIRED: {
                    throw new LicenseException(this.i18n2.get().getText("jira.software.license.expired"));
                }
                case USERS_EXCEEDED: {
                    throw new LicenseException(this.i18n2.get().getText("jira.software.license.jira.user.limit.reached"));
                }
                case VERSION_MISMATCH: {
                    throw new LicenseException(this.i18n2.get().getText("jira.software.license.version.mismatch"));
                }
            }
            throw new LicenseException(this.i18n2.get().getText("jira.software.license.not.licensed.with.message") + " " + ((ApplicationAccess.AccessError)accessError.get()).name());
        }
    }

    @Override
    public Collection<ApplicationAccess.AccessError> getSoftwareLicensingAccessErrors() {
        return this.applicationAuthorizationService.getLicensingAccessErrors(SOFTWARE_KEY);
    }
}

