/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.license;

import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.license.LicenseInfo;
import com.atlassian.greenhopper.license.LicenseMode;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.license.SoftwareAuthorizationService;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.pyxis.greenhopper.jira.license.GreenHopperLicenseManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
implements LicenseService {
    @Autowired
    private GreenHopperLicenseManager greenHopperLicenseManager;
    @Autowired
    private JiraForSoftwareChecker jiraForSoftwareChecker;
    @Autowired
    private SoftwareAuthorizationService softwareAuthorizationService;

    @Override
    public String getLicenseAdminUrl(LicenseMode licenseMode) {
        switch (licenseMode) {
            case AGILE: {
                return String.format("/plugins/servlet/upm#manage/%s", "com.pyxis.greenhopper.jira");
            }
        }
        return "/plugins/servlet/applications/versions-licenses";
    }

    @Override
    public LicenseInfo getLicenseInfo(ApplicationUser user) {
        LicenseInfo.Builder builder = LicenseInfo.builder();
        boolean isLicensed = this.greenHopperLicenseManager.isValid();
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
            builder.setLicenseMode(LicenseMode.SOFTWARE).setLicensed(isLicensed).setValidUser(isLicensed && user != null && this.isValidSoftwareUser(user));
        } else {
            builder.setLicenseMode(LicenseMode.AGILE).setLicensed(isLicensed).setValidUser(isLicensed);
        }
        return builder.build();
    }

    @Override
    public boolean isLicensed() {
        return this.getLicenseInfo(null).isLicensed();
    }

    @Override
    public boolean isValidUser(ApplicationUser user) {
        return this.getLicenseInfo(user).isValidUser();
    }

    @Override
    public ServiceResult validateUser(ApplicationUser user) {
        if (this.isValidUser(user)) {
            return ServiceResultImpl.ok();
        }
        ErrorCollection errorCollection = new ErrorCollection();
        errorCollection.addError(ErrorCollection.Reason.FORBIDDEN, "gh.license.no.access", new Object[0]);
        return ServiceResultImpl.from(errorCollection);
    }

    @VisibleForTesting
    boolean isValidSoftwareUser(ApplicationUser user) {
        return this.softwareAuthorizationService.canUseApplication(user);
    }
}

