/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.jira.filters;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.ClassicBoardRequestAnalyticEvent;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ClassicBoardRouter
implements Filter {
    private final EventPublisher eventPublisher;
    private static final List<String> CLASSIC_BOARD_ACTIONS;
    private static final Pattern ACTION_PATTERN;

    public ClassicBoardRouter(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (ClassicBoardRouter.isClassicBoardRequest(servletRequest)) {
            this.trackTrafficToClassicBoard();
            servletRequest.getRequestDispatcher("/secure/ClassicBoardNotFound.jspa").forward(servletRequest, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    @VisibleForTesting
    static boolean isClassicBoardRequest(ServletRequest request) {
        if (!HttpServletRequest.class.isInstance(request)) {
            throw new IllegalArgumentException("Request must be a HTTP request");
        }
        return CLASSIC_BOARD_ACTIONS.contains(ClassicBoardRouter.actionFromRequest(ClassicBoardRouter.servletPathOfRequest((HttpServletRequest)request)));
    }

    @VisibleForTesting
    static String servletPathOfRequest(HttpServletRequest request) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)request.getAttribute("javax.servlet.include.servlet_path")), (CharSequence)request.getServletPath());
    }

    @VisibleForTesting
    static String actionFromRequest(String servletPath) {
        if (servletPath == null) {
            throw new IllegalArgumentException("Servlet path must not be null");
        }
        Matcher matcher = ACTION_PATTERN.matcher(servletPath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return servletPath;
    }

    private void trackTrafficToClassicBoard() {
        this.eventPublisher.publish((Object)new ClassicBoardRequestAnalyticEvent());
    }

    static {
        ACTION_PATTERN = Pattern.compile("(\\w+)(\\.jspa.*|$)");
        CLASSIC_BOARD_ACTIONS = Arrays.asList("VersionBoard", "TaskBoard", "ArchiveChartBoard", "ComponentBoard", "AssigneeBoard", "ProjectBoard", "ChartBoard", "Configuration");
    }
}

