/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.jira.dataimport;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.dataimport.DataImportOSPropertyValidator;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;

public class BuildNumberValidator
implements DataImportOSPropertyValidator {
    private static final Set<String> PROPERTY_KEYS_TO_VALIDATE = Sets.newHashSet((Object[])new String[]{"GreenHopper.Upgrade.Latest.Upgraded.Version"});
    private static final String VALIDATION_ERROR_LEARN_MORE_LINK_SERVER = "https://confluence.atlassian.com/agile/jira-agile-releases/jira-agile-release-notes/jira-agile-6-7-release-notes/jira-agile-6-7-upgrade-notes";
    private static final String VALIDATION_ERROR_LEARN_MORE_LINK_CLOUD = "https://confluence.atlassian.com/display/JIRAKB/Unable+to+import+JIRA+backup+into+JIRA+Cloud+due+to+incompatible+JIRA+Agile+data+from+a+previous+Agile+version";
    private final JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    private final FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);

    public Set<String> getPropertyKeysToValidate() {
        return PROPERTY_KEYS_TO_VALIDATE;
    }

    public ServiceResult validate(DataImportParams dataImportParams, DataImportOSPropertyValidator.DataImportProperties dataImportProperties) {
        ServiceResultImpl result = new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
        Optional lastUpgradeTaskBuildNumber = dataImportProperties.getNumberProperty("GreenHopper.Upgrade.Latest.Upgraded.Version");
        if (lastUpgradeTaskBuildNumber.isPresent() && (Long)lastUpgradeTaskBuildNumber.get() < 45L) {
            String errorMessage = this.jiraAuthenticationContext.getI18nHelper().getText("agile.build.number.data.import.validation.error", "<a href=\"" + this.getLearnMoreLink() + "\">", "</a>");
            result.getErrorCollection().addErrorMessage(errorMessage);
        }
        return result;
    }

    private String getLearnMoreLink() {
        return this.featureManager.isOnDemand() ? VALIDATION_ERROR_LEARN_MORE_LINK_CLOUD : VALIDATION_ERROR_LEARN_MORE_LINK_SERVER;
    }
}

