/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.jira.actions;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.ActionViewData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkCommentDialogAction
extends GreenHopperWebActionSupport {
    @VisibleForTesting
    static final String ADD_COMMENT_ACTION_REDIRECT_URL = "/secure/AddComment!default.jspa?key={0}&decorator=dialog&inline=true";
    @VisibleForTesting
    static final String ISSUE_FIND_ERROR_VIEW = "issue_find_error";
    @VisibleForTesting
    static final String PERMISSION_ERROR_VIEW = "permission_error";
    private final IssueFinder issueFinder;
    private final PermissionManager permissionManager;
    private String issueKeys;
    private IssueFindResult issueFindResult;
    private PermissionCheckResult permissionCheckResult;

    @Autowired
    public BulkCommentDialogAction(IssueFinder issueFinder, PermissionManager permissionManager) {
        this.issueFinder = issueFinder;
        this.permissionManager = permissionManager;
    }

    public String doShow() {
        this.issueFindResult = this.findIssues(this.issueKeys);
        if (this.issueFindResult.hasAnyError()) {
            return ISSUE_FIND_ERROR_VIEW;
        }
        this.permissionCheckResult = this.checkAddCommentPermission(this.issueFindResult.issues);
        if (this.permissionCheckResult.hasAnyError()) {
            return PERMISSION_ERROR_VIEW;
        }
        return this.getRedirect(MessageFormat.format(ADD_COMMENT_ACTION_REDIRECT_URL, ((Issue)this.issueFindResult.issues.get(0)).getKey()));
    }

    @ActionViewData
    public Map<String, Object> getViewDataMap() {
        HashMap viewData = Maps.newHashMap();
        viewData.put("issueKeysNotFoundCount", this.issueFindResult.issueKeysNotFound.size());
        viewData.put("issueKeysNotFound", Joiner.on((String)", ").join((Iterable)this.issueFindResult.issueKeysNotFound));
        viewData.put("issueKeysWithBrowsePermissionErrorCount", this.issueFindResult.issueKeysCannotBrowse.size());
        viewData.put("issueKeysWithBrowsePermissionError", Joiner.on((String)", ").join((Iterable)this.issueFindResult.issueKeysCannotBrowse));
        if (this.permissionCheckResult != null) {
            List issueKeysWithPermissionError = this.permissionCheckResult.issueKeysWithPermissionError;
            viewData.put("issueKeysWithPermissionErrorCount", issueKeysWithPermissionError.size());
            viewData.put("issueKeysWithPermissionError", Joiner.on((String)", ").join((Iterable)issueKeysWithPermissionError));
        }
        return viewData;
    }

    private IssueFindResult findIssues(String issueKeys) {
        IssueFindResult issueFindResult = new IssueFindResult();
        for (String issueKey : issueKeys.split(",")) {
            SimpleErrorCollection issueFindErrors = new SimpleErrorCollection();
            Issue issue = this.issueFinder.findIssue(issueKey, (com.atlassian.jira.util.ErrorCollection)issueFindErrors);
            if (issue != null && !issueFindErrors.hasAnyErrors()) {
                issueFindResult.issues.add(issue);
                continue;
            }
            ErrorCollection errorCollection = ErrorCollection.fromJiraErrorCollectionWithReasons((com.atlassian.jira.util.ErrorCollection)issueFindErrors);
            if (errorCollection.getDefinitiveReason() == ErrorCollection.Reason.NOT_FOUND) {
                issueFindResult.issueKeysNotFound.add(issueKey);
                continue;
            }
            issueFindResult.issueKeysCannotBrowse.add(issueKey);
        }
        return issueFindResult;
    }

    private PermissionCheckResult checkAddCommentPermission(Collection<Issue> issues) {
        PermissionCheckResult permissionCheckResult = new PermissionCheckResult();
        for (Issue issue : issues) {
            if (this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issue, this.getLoggedInUser())) continue;
            permissionCheckResult.issueKeysWithPermissionError.add(issue.getKey());
        }
        return permissionCheckResult;
    }

    public void setIssueKeys(String issueKeys) {
        this.issueKeys = issueKeys;
    }

    private static final class PermissionCheckResult {
        private final List<String> issueKeysWithPermissionError = Lists.newArrayList();

        private PermissionCheckResult() {
        }

        private boolean hasAnyError() {
            return !this.issueKeysWithPermissionError.isEmpty();
        }
    }

    private static final class IssueFindResult {
        private final List<Issue> issues = Lists.newArrayList();
        private final List<String> issueKeysNotFound = Lists.newArrayList();
        private final List<String> issueKeysCannotBrowse = Lists.newArrayList();

        private IssueFindResult() {
        }

        private boolean hasAnyError() {
            return !this.issueKeysNotFound.isEmpty() || !this.issueKeysCannotBrowse.isEmpty();
        }
    }
}

