/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.jira;

import com.atlassian.greenhopper.jira.JIRAResource;
import com.atlassian.jira.component.ComponentAccessor;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class JIRAResourceAnnotationBeanPostProcessor
implements BeanPostProcessor {
    private final Logger log = Logger.getLogger(this.getClass());

    public Object postProcessBeforeInitialization(final Object bean, final String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.isAnnotationPresent(JIRAResource.class)) {
                    Object jiraResource = ComponentAccessor.getComponentOfType(field.getType());
                    if (jiraResource == null) {
                        String message = "Unable to inject JIRA managed component of type " + field.getType() + ": No such component defined";
                        JIRAResourceAnnotationBeanPostProcessor.this.log.error((Object)message);
                        throw new BeanCreationException(beanName, message);
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(bean, jiraResource);
                }
            }
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

