/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.util;

import com.atlassian.core.util.FileSize;
import com.atlassian.greenhopper.issue.util.AttachmentZipExtractor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.FileIconUtil;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultAttachmentZipExtractor
implements AttachmentZipExtractor {
    private final Logger log = Logger.getLogger(DefaultAttachmentZipExtractor.class);
    private final FileIconUtil fileIconUtil;
    private final AttachmentIndexManager attachmentIndexManager;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public DefaultAttachmentZipExtractor(ApplicationProperties applicationProperties, FileIconUtil fileIconUtil, AttachmentIndexManager attachmentIndexManager) {
        this.applicationProperties = applicationProperties;
        this.fileIconUtil = fileIconUtil;
        this.attachmentIndexManager = attachmentIndexManager;
    }

    @Override
    public Option<AttachmentZipExtractor.ZipContents> getZipContents(Attachment attachment, Issue issue) {
        int maximumNumberOfZipEntriesToShow = this.getMaximumNumberOfZipEntriesToShow();
        Option<AttachmentArchive> archive = this.failsafeGetAttachmentContents(attachment, issue, maximumNumberOfZipEntriesToShow);
        if (archive.isDefined() && ((AttachmentArchive)archive.get()).getTotalNumberOfEntriesAvailable() > 0) {
            AttachmentArchive attachmentArchive = (AttachmentArchive)archive.get();
            ArrayList entries = Lists.newArrayList();
            for (AttachmentArchiveEntry zipEntry : attachmentArchive.getEntries()) {
                AttachmentZipExtractor.ZipEntry entry = new AttachmentZipExtractor.ZipEntry(zipEntry.getName(), FileSize.format((long)zipEntry.getSize()), zipEntry.getAbbreviatedName(), this.createZipEntryUrl(issue, attachment, zipEntry), this.getIcon(zipEntry));
                entries.add(entry);
            }
            AttachmentZipExtractor.ZipContents contents = new AttachmentZipExtractor.ZipContents(attachmentArchive.isMoreAvailable(), maximumNumberOfZipEntriesToShow, attachmentArchive.getTotalNumberOfEntriesAvailable(), entries);
            return Option.option((Object)contents);
        }
        return Option.none();
    }

    private Option<AttachmentArchive> failsafeGetAttachmentContents(Attachment attachment, Issue issue, int maximumNumberOfZipEntriesToShow) {
        try {
            return this.attachmentIndexManager.getAttachmentContents(attachment, issue, maximumNumberOfZipEntriesToShow);
        }
        catch (RuntimeException e) {
            this.log.error((Object)("unexpected RTE whilst retrieving content for attachment " + attachment.getId()));
            this.log.debug((Object)e);
            return Option.none();
        }
    }

    private AttachmentZipExtractor.IconEntry getIcon(AttachmentArchiveEntry zipEntry) {
        FileIconBean.FileIcon fileIcon = this.fileIconUtil.getFileIcon(zipEntry.getName(), null);
        return new AttachmentZipExtractor.IconEntry("/images/icons/attach/" + (fileIcon == null ? "file.gif" : fileIcon.getIcon()), fileIcon == null ? "File" : fileIcon.getAltText());
    }

    private String createZipEntryUrl(Issue issue, Attachment attachment, AttachmentArchiveEntry zipEntry) {
        return String.format("/secure/attachmentzip/unzip/%d/%d[%d]/%s", issue.getId(), attachment.getId(), zipEntry.getEntryIndex(), zipEntry.getName());
    }

    private int getMaximumNumberOfZipEntriesToShow() {
        String maximumNumberOfZipEntriesToShowAsString = this.applicationProperties.getDefaultBackedString("jira.attachment.number.of.zip.entries");
        return NumberUtils.toInt((String)maximumNumberOfZipEntriesToShowAsString, (int)30);
    }
}

