/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.link;

import com.atlassian.greenhopper.issue.link.RemoteIssueLinkSearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.plugin.issuelink.IssueLinkRenderer;
import com.atlassian.jira.plugin.issuelink.IssueLinkRendererModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.plugin.viewissue.issuelink.RemoteIssueLinkComparator;
import com.atlassian.jira.plugin.viewissue.issuelink.RemoteIssueLinkUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteIssueLinkSearchServiceImpl
implements RemoteIssueLinkSearchService {
    @Autowired
    private RemoteIssueLinkManager remoteIssueLinkManager;
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private PluginAccessor pluginAccessor;
    @Autowired
    private VelocityRequestContextFactory velocityRequestContextFactory;

    public List<RemoteIssueLink> getRemoteLinksForIssue(Issue issue) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        ArrayList remoteIssueLinks = Lists.newArrayList((Iterable)this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue));
        Collections.sort(remoteIssueLinks, new RemoteIssueLinkComparator(i18n.getText("issuelinking.remote.link.relationship.default")));
        return remoteIssueLinks;
    }

    @Override
    public List<RemoteIssueLink> getRemoteLinksForIssue(Issue issue, final String applicationType) {
        List<RemoteIssueLink> remoteIssueLinks = this.getRemoteLinksForIssue(issue);
        Iterable filteredLinks = Iterables.filter(remoteIssueLinks, (Predicate)new Predicate<RemoteIssueLink>(){

            public boolean apply(@Nullable RemoteIssueLink remoteIssueLink) {
                return applicationType.equals(remoteIssueLink.getApplicationType());
            }
        });
        return Lists.newArrayList((Iterable)filteredLinks);
    }

    @Override
    public Map<String, List<IssueLinkContext>> getRemoteIssueLinkContexts(Issue issue) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        List<RemoteIssueLink> remoteLinksForIssue = this.getRemoteLinksForIssue(issue);
        return RemoteIssueLinkUtils.convertToIssueLinkContexts(remoteLinksForIssue, (Long)issue.getId(), (String)baseUrl, (I18nHelper)this.authenticationContext.getI18nHelper(), (PluginAccessor)this.pluginAccessor);
    }

    @Override
    public Map<String, Object> getUpdatedContext(RemoteIssueLink issueLink) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueLinkRendererModuleDescriptor.class);
        for (IssueLinkRendererModuleDescriptor descriptor : descriptors) {
            if (!descriptor.handlesApplicationType(issueLink.getApplicationType())) continue;
            IssueLinkRenderer module = (IssueLinkRenderer)descriptor.getModule();
            return module.getFinalContext(issueLink, this.createVelocityParams());
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> createVelocityParams() {
        Map params = this.velocityRequestContextFactory.getDefaultVelocityParams(Collections.emptyMap(), this.authenticationContext);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!params.containsKey("i18n")) {
            result.put("i18n", this.authenticationContext.getI18nHelper());
        }
        result.put("descriptor", this);
        return CompositeMap.of(result, (Map)params);
    }
}

