/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.link;

import com.atlassian.greenhopper.issue.fields.status.IssueStatus;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.greenhopper.web.rapid.issue.IconEntry;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntry;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.issuelink.IssueLinkModel;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.google.common.base.Function;
import java.util.Map;

class IssueLinkContextTransformer
implements Function<IssueLinkContext, IssueLinkModel.IssueLinkEntry> {
    private final IssueHelper issueHelper;
    private final IssueStatusService issueStatusService;
    private final StatusEntryFactory statusEntryFactory;

    IssueLinkContextTransformer(IssueHelper issueHelper, IssueStatusService issueStatusService, StatusEntryFactory statusEntryFactory) {
        this.issueHelper = issueHelper;
        this.issueStatusService = issueStatusService;
        this.statusEntryFactory = statusEntryFactory;
    }

    public IssueLinkModel.IssueLinkEntry apply(IssueLinkContext input) {
        IssueLinkModel.IssueLinkEntry entry = input.isRemote() ? this.getRemote(input) : this.getLocal(input);
        entry.deleteUrl = input.getDeleteUrl();
        entry.htmlElementId = input.getHtmlElementId();
        entry.remote = input.isRemote();
        entry.requiresAsyncLoading = input.isRequiresAsyncLoading();
        return entry;
    }

    private IssueLinkModel.IssueLinkEntry getRemote(IssueLinkContext input) {
        IssueLinkModel.RemoteIssueLinkEntry entry = new IssueLinkModel.RemoteIssueLinkEntry();
        entry.id = input.getId();
        entry.html = input.getHtml();
        return entry;
    }

    private IssueLinkModel.IssueLinkEntry getLocal(IssueLinkContext input) {
        IssueLinkModel.LocalIssueLinkEntry entry = new IssueLinkModel.LocalIssueLinkEntry();
        Map map = input.getMap();
        entry.linkIcon = new IconEntry((String)map.get("iconUrl"), (String)map.get("iconTooltip"));
        entry.statusIcon = new IconEntry((String)map.get("statusIconUrl"), (String)map.get("statusIconTooltip"));
        entry.priorityIcon = new IconEntry((String)map.get("priorityIconUrl"), (String)map.get("priorityIconTooltip"));
        entry.statusIconLink = (String)map.get("statusIconLink");
        entry.resolved = (Boolean)map.get("resolved");
        entry.summary = (String)map.get("summary");
        entry.title = (String)map.get("title");
        entry.tooltip = (String)map.get("tooltip");
        entry.url = (String)map.get("url");
        Object statusObject = map.get("status");
        if (statusObject != null) {
            entry.status = this.createStatusEntry(this.issueStatusService.getIssueStatus(statusObject));
        } else {
            ServiceOutcome<Issue> issueOutcome;
            String issueKey = (String)map.get("issueKey");
            if (issueKey != null && (issueOutcome = this.issueHelper.findIssue(issueKey)).isValid()) {
                entry.status = this.createStatusEntry(this.issueStatusService.getIssueStatus(issueOutcome.getValue().getStatusObject()));
            }
        }
        return entry;
    }

    private StatusEntry createStatusEntry(IssueStatus issueStatus) {
        return this.statusEntryFactory.createStatusEntry(issueStatus);
    }
}

