/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.index;

import com.atlassian.greenhopper.issue.index.FindQueriesMatchingIssue;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.TemporaryIndexProvider;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindQueriesMatchingIssueImpl
implements FindQueriesMatchingIssue {
    private final TemporaryIndexProvider temporaryIndexProvider;

    @Autowired
    public FindQueriesMatchingIssueImpl(TemporaryIndexProvider temporaryIndexProvider) {
        this.temporaryIndexProvider = temporaryIndexProvider;
    }

    @Override
    @Nonnull
    public Set<Query> findQueries(final @Nonnull ApplicationUser user, final @Nonnull Map<Issue, Collection<Query>> issuesAndQueries) throws SearchException {
        try {
            return (Set)Assertions.notNull((Object)this.temporaryIndexProvider.indexIssuesAndSearch(issuesAndQueries.keySet(), (TemporaryIndexProvider.IndexSearcher)new TemporaryIndexProvider.IndexSearcher<Set<Query>>(){

                public Set<Query> search(SearchProvider searchProvider) throws SearchException {
                    return FindQueriesMatchingIssueImpl.this.findQueries(searchProvider, user, issuesAndQueries);
                }
            }));
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Nonnull
    private Set<Query> findQueries(@Nonnull SearchProvider searchProvider, @Nonnull ApplicationUser user, @Nonnull Map<Issue, Collection<Query>> issuesAndQueries) throws SearchException {
        HashSet matching = Sets.newHashSet();
        for (Issue issue : issuesAndQueries.keySet()) {
            for (Query query : issuesAndQueries.get(issue)) {
                Query issueQuery = JqlQueryBuilder.newBuilder((Query)query).where().defaultAnd().issue().eq(issue.getId()).buildQuery();
                long count = searchProvider.getHitCount(SearchQuery.create((Query)issueQuery, (ApplicationUser)user).overrideSecurity(true));
                if (count <= 0L) continue;
                matching.add(query);
            }
        }
        return matching;
    }
}

