/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.fields;

import com.atlassian.greenhopper.issue.fields.FieldCacheRefreshService;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.manager.CachedOptionsManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FieldCacheRefreshServiceImpl
implements FieldCacheRefreshService {
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private OptionsManager optionsManager;
    @Autowired
    private CustomFieldManager customFieldManager;

    @Override
    public void refreshAfterChangingCustomFieldContext(CustomField customField) {
        this.fieldManager.refresh();
        this.customFieldManager.refreshConfigurationSchemes(customField.getIdAsLong());
        this.customFieldManager.refresh();
    }

    @Override
    public void refreshOptionCaches() throws IllegalStateException {
        if (!(this.optionsManager instanceof CachedOptionsManager)) {
            throw new IllegalStateException("Expected to have a Cached OptionsManager: " + this.optionsManager.getClass());
        }
        ((CachedOptionsManager)this.optionsManager).onClearCache(ClearCacheEvent.INSTANCE);
    }
}

