/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.fields;

import com.atlassian.greenhopper.issue.fields.CustomFieldUpdateService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFieldUpdateServiceImpl
implements CustomFieldUpdateService {
    private final CustomFieldManager customFieldManager;

    @Autowired
    public CustomFieldUpdateServiceImpl(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public void updateName(CustomField field, String newName) {
        this.customFieldManager.updateCustomField(field.getIdAsLong(), newName, field.getUntranslatedDescription(), field.getCustomFieldSearcher());
    }

    @Override
    public void updateDescription(CustomField field, String newDescription) {
        this.customFieldManager.updateCustomField(field.getIdAsLong(), field.getUntranslatedName(), newDescription, field.getCustomFieldSearcher());
    }

    @Override
    public void updateNameAndDescription(CustomField field, String newName, String newDescription) {
        this.customFieldManager.updateCustomField(field.getIdAsLong(), newName, newDescription, field.getCustomFieldSearcher());
    }

    @Override
    public void updateFieldSearcher(CustomField field, CustomFieldSearcher searcher) {
        this.customFieldManager.updateCustomField(field.getIdAsLong(), field.getUntranslatedName(), field.getUntranslatedDescription(), field.getCustomFieldSearcher());
    }
}

