/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue.detailsview;

import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.TemplateType;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.web.dispatcher.SoyTemplateAddress;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IssueDetailsViewPanel
implements WebPanel {
    private final ContextProvider contextProvider;
    private final Iterable<ResourceDescriptor> resourceDescriptors;
    private final VelocityTemplatingEngine velocityTemplatingEngine;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;

    public IssueDetailsViewPanel(ContextProvider contextProvider, Iterable<ResourceDescriptor> resourceDescriptors, VelocityTemplatingEngine velocityTemplatingEngine, SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.contextProvider = contextProvider;
        this.resourceDescriptors = resourceDescriptors;
        this.velocityTemplatingEngine = velocityTemplatingEngine;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    public String getHtml(Map<String, Object> map) {
        try {
            StringWriter sink = new StringWriter();
            this.writeHtml(sink, this.contextProvider.getContextMap(map));
            return sink.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeHtml(Writer writer, Map<String, Object> map) throws IOException {
        for (ResourceDescriptor resource : this.resourceDescriptors) {
            if (!StringUtils.isNotBlank((CharSequence)resource.getLocation())) continue;
            if (TemplateType.VELOCITY.equalsIgnoreCase(resource.getType())) {
                this.velocityTemplatingEngine.render(TemplateSources.file((String)resource.getLocation())).applying(map).asHtml(writer);
                break;
            }
            if (!TemplateType.SOY.equalsIgnoreCase(resource.getType())) break;
            SoyTemplateAddress soy = SoyTemplateAddress.address(null, (String)resource.getLocation());
            this.getSoyRenderer().render((Appendable)writer, soy.getCompleteKey(), soy.getTemplateName(), map);
            break;
        }
    }

    private SoyTemplateRenderer getSoyRenderer() {
        return this.soyTemplateRendererProvider.getRenderer();
    }
}

