/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue;

import com.atlassian.greenhopper.service.issue.AbstractIssueEventListener;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoveFutureSprintsFromClosedIssuesListener
extends AbstractIssueEventListener {
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private IssueManager issueManager;

    @Override
    protected void doOnIssueEvent(Long typeId, Issue issue, IssueEvent event) {
        CustomField sprintField;
        List<Sprint> issueSprints;
        boolean hasFutureSprints;
        if (EventType.ISSUE_CLOSED_ID.equals(typeId) && !issue.isEditable() && !issue.isSubTask() && (hasFutureSprints = Iterables.any(issueSprints = this.getExistingSprints(issue, sprintField = this.sprintCustomFieldService.getDefaultSprintField()), SprintUtils.SPRINT_FUTURE))) {
            Iterables.removeIf(issueSprints, SprintUtils.SPRINT_FUTURE);
            this.updateIssueSprints(event.getUser(), issue, issueSprints, sprintField);
        }
    }

    private MutableIssue updateIssueSprints(ApplicationUser executivedUser, Issue issue, List<Sprint> issueSprints, CustomField sprintField) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        HashMap fieldValuesHolder = new HashMap();
        MutableIssue updatedIssue = this.issueManager.getIssueObject(issue.getId());
        updatedIssue.setCustomFieldValue(sprintField, issueSprints);
        IssueService.UpdateValidationResult updateValidationResult = new IssueService.UpdateValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder);
        this.issueUpdateService.update(executivedUser, updateValidationResult);
        return updatedIssue;
    }

    private List<Sprint> getExistingSprints(Issue issue, CustomField sprintField) {
        Collection customFieldValue = (Collection)issue.getCustomFieldValue(sprintField);
        ArrayList<Sprint> values = new ArrayList<Sprint>();
        if (customFieldValue != null) {
            values.addAll(customFieldValue);
        }
        return values;
    }
}

