/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.issue;

import com.atlassian.greenhopper.issue.IssuePermissionService;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuePermissionServiceImpl
implements IssuePermissionService {
    @Autowired
    private PermissionManager permissionManager;

    @Override
    @Nonnull
    public ServiceResult canEditAllIssues(@Nullable ApplicationUser user, List<Issue> issues) {
        List forbiddenIssues = issues.stream().filter(issue -> !this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user)).collect(Collectors.toList());
        if (forbiddenIssues.isEmpty()) {
            return ServiceResultImpl.ok();
        }
        String forbiddenKeyString = forbiddenIssues.stream().map(Issue::getKey).collect(Collectors.joining(", "));
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.error.issues.notpermitted", forbiddenIssues.size(), forbiddenKeyString);
    }
}

