/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.imports;

import com.atlassian.greenhopper.imports.ImportAnalyticsPublisher;
import com.atlassian.greenhopper.imports.ProjectImportService;
import com.atlassian.greenhopper.imports.SprintImportMapper;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ao.handler.PluggableImportAoEntityHandler;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SprintImportHandler
implements PluggableImportAoEntityHandler {
    @Autowired
    private ProjectImportService projectImportService;
    @Autowired
    private ImportAnalyticsPublisher importAnalyticsPublisher;
    private SprintImportMapper sprintImportMapper;
    private SimpleProjectImportIdMapper issueMapper;
    private long sprintsImportedCount;

    public void handleEntity(String aoTableName, Map<String, Object> attributes) throws ParseException, AbortImportException {
        if (!"AO_60DB71_SPRINT".equals(aoTableName)) {
            throw new IllegalArgumentException("expecting table AO_60DB71_SPRINT");
        }
        String oldSprintId = Long.toString((Long)attributes.get("ID"));
        if (this.sprintImportMapper.getSprints().contains(oldSprintId)) {
            String oldSprintName = (String)attributes.get("NAME");
            this.sprintImportMapper.registerOldValue(oldSprintId, oldSprintName);
            HashMap<String, Object> fields = new HashMap<String, Object>(attributes);
            fields.put("RAPID_VIEW_ID", null);
            fields.remove("ID");
            ServiceOutcome<Long> createSprintOutcome = this.projectImportService.createSprint(fields);
            if (!createSprintOutcome.isValid()) {
                throw new AbortImportException();
            }
            this.sprintImportMapper.mapValue(attributes.get("ID").toString(), String.valueOf(createSprintOutcome.get()));
            ++this.sprintsImportedCount;
        }
    }

    public boolean handlesEntity(String aoTableName) {
        return "AO_60DB71_SPRINT".equals(aoTableName);
    }

    public Long getEntityWeight(String aoTableName) {
        if ("AO_60DB71_SPRINT".equals(aoTableName)) {
            return 10000L;
        }
        return PluggableImportAoEntityHandler.WEIGHT_NONE;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void endTable(String aoTableName) {
        this.sprintImportMapper.setSprintsImported();
        if ("AO_60DB71_SPRINT".equals(aoTableName)) {
            for (String oldIssueId : this.sprintImportMapper.getIssuesWithSprint()) {
                Long issueId = Long.valueOf(this.issueMapper.getMappedId(oldIssueId));
                for (String oldSprintId : this.sprintImportMapper.getSprintsFromIssue(oldIssueId)) {
                    Long newSprintId = Long.valueOf(this.sprintImportMapper.getMappedId(oldSprintId));
                    this.projectImportService.addSprintCFValue(issueId, newSprintId);
                }
            }
        }
        this.importAnalyticsPublisher.publishProjectImportedEvent(this.sprintsImportedCount);
    }

    public void setBackupProject(BackupProject backupProject) {
    }

    public void setBackupSystemInformation(BackupSystemInformation backupSystemInformation) {
    }

    public void setProjectImportMapper(ProjectImportMapper projectImportMapper) {
        this.sprintImportMapper = (SprintImportMapper)projectImportMapper.getNamedIdMapper("sprintMapper");
        this.issueMapper = projectImportMapper.getIssueMapper();
        this.sprintsImportedCount = 0L;
    }

    public void setProjectImportResults(ProjectImportResults projectImportResults) {
    }
}

