/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.imports;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.imports.ProjectImportService;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectImportServiceImpl
implements ProjectImportService {
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private CustomFieldValuePersister customFieldValuePersister;
    @Autowired
    LexoRankManager lexoRankManager;
    @Autowired
    CustomFieldManager customFieldManager;
    @Autowired
    LexoRankCustomFieldService lexoRankCustomFieldService;

    @Override
    public ServiceOutcome<Long> createSprint(Map<String, Object> fields) {
        com.atlassian.greenhopper.service.ServiceOutcome<Sprint> createSprintOutcome = this.sprintManager.createSprint(fields);
        if (createSprintOutcome.isValid()) {
            return ServiceOutcomeImpl.ok((Object)createSprintOutcome.get().getId());
        }
        return ServiceOutcomeImpl.from((ErrorCollection)this.errorCollectionTransformer.toJiraErrorCollection(createSprintOutcome.getErrors()), null);
    }

    @Override
    public void addSprintCFValue(Long issueId, Long sprintId) {
        CustomField sprintCustomField = this.sprintCustomFieldService.getDefaultSprintField();
        List values = this.customFieldValuePersister.getValues(sprintCustomField, issueId, PersistenceFieldType.TYPE_LIMITED_TEXT);
        ArrayList<String> newValues = new ArrayList<String>(values);
        newValues.add(sprintId.toString());
        this.customFieldValuePersister.updateValues(sprintCustomField, issueId, PersistenceFieldType.TYPE_LIMITED_TEXT, newValues);
    }

    @Override
    public ServiceOutcome<Void> rankAfter(Long fieldId, Long issueId, @Nullable Long previousIssueId) {
        LexoRankOperationOutcome<LexoRankChange> outcome = this.lexoRankManager.getRankOrRankInitially(fieldId, issueId, false);
        if (outcome.isValid()) {
            if (outcome.getResult().wasChanged() || previousIssueId == null) {
                return ServiceOutcomeImpl.ok(null);
            }
        } else if (previousIssueId == null) {
            return ServiceOutcomeImpl.error((String)("Error creating rank for field[" + fieldId + "], issue[" + issueId + "]"));
        }
        if ((outcome = this.lexoRankManager.rankAfter(fieldId, issueId, previousIssueId)).isValid()) {
            return ServiceOutcomeImpl.ok(null);
        }
        return ServiceOutcomeImpl.error((String)("Error ranking field[" + fieldId + "], issue[" + issueId + "] after issue[" + previousIssueId + "]"));
    }

    @Override
    public Long getDefaultRankFieldId() {
        return this.lexoRankCustomFieldService.getDefaultRankField().getIdAsLong();
    }

    @Override
    public List<Long> getRankFieldIds() {
        ArrayList<Long> rankFieldIds = new ArrayList<Long>();
        for (CustomField customField : this.lexoRankCustomFieldService.getRankFields()) {
            rankFieldIds.add(customField.getIdAsLong());
        }
        return rankFieldIds;
    }
}

