/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.imports;

import com.atlassian.greenhopper.imports.LexorankImportMapper;
import com.atlassian.greenhopper.imports.ProjectImportService;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ao.handler.PluggableImportAoEntityHandler;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LexorankPreImportHandler
implements PluggableImportAoEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(PluggableImportAoEntityHandler.class);
    private static final String TYPE = "TYPE";
    private static final String ISSUE_ID = "ISSUE_ID";
    private static final String FIELD_ID = "FIELD_ID";
    private static final String RANK = "RANK";
    private static final long RANK_TYPE = 1L;
    private final CustomFieldManager customFieldManager;
    private final ProjectImportService projectImportService;
    private BackupProject backupProject;
    private Set<Long> handledRankFields;
    private Set<Long> unmatchedRankFields;
    private LexorankImportMapper mapper;

    @Autowired
    public LexorankPreImportHandler(CustomFieldManager customFieldManager, ProjectImportService projectImportService) {
        this.customFieldManager = customFieldManager;
        this.projectImportService = projectImportService;
    }

    public void handleEntity(String aoTableName, Map<String, Object> map) throws ParseException, AbortImportException {
        if (this.getAsLong(map, TYPE).equals(1L)) {
            Long oldIssueId = this.getAsLong(map, ISSUE_ID);
            Long oldFieldId = this.getAsLong(map, FIELD_ID);
            if (this.backupProject.containsIssue(oldIssueId.toString())) {
                this.mapper.registerOldRankValue(oldFieldId, oldIssueId, map.get(RANK).toString());
                if (this.handledRankFields.add(oldFieldId)) {
                    this.addFieldMapping(oldFieldId);
                }
            }
        }
    }

    private Long getAsLong(Map<String, Object> map, String key) {
        return Long.valueOf(map.get(key).toString());
    }

    private void addFieldMapping(Long oldFieldId) {
        ExternalCustomFieldConfiguration customFieldConfiguration = this.backupProject.getCustomFieldConfiguration(oldFieldId.toString());
        String name = customFieldConfiguration.getCustomField().getName();
        CustomField customField = this.customFieldManager.getCustomFieldObjectByName(name);
        if (customField != null) {
            this.mapper.mapFieldId(oldFieldId, customField.getIdAsLong());
        } else {
            this.unmatchedRankFields.add(oldFieldId);
            log.info("Rank field [{}] does not exist in the target system, these ranks will not be imported", (Object)oldFieldId);
        }
    }

    public boolean handlesEntity(String s) {
        return "AO_60DB71_LEXORANK".equals(s);
    }

    public Long getEntityWeight(String s) {
        return "AO_60DB71_LEXORANK".equals(s) ? 10002L : PluggableImportAoEntityHandler.WEIGHT_NONE;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void endTable(String s) {
        Long oldDefaultRankFieldId = this.mapper.getOldDefaultRankFieldId();
        if (this.unmatchedRankFields.contains(oldDefaultRankFieldId)) {
            this.handleUnmappedDefault(oldDefaultRankFieldId);
        }
        this.backupProject = null;
        this.handledRankFields = null;
        this.unmatchedRankFields = null;
        this.mapper = null;
    }

    private void handleUnmappedDefault(Long oldDefaultRankFieldId) {
        Long newDefaultRankFieldId = this.projectImportService.getDefaultRankFieldId();
        if (!this.mapper.getNewFieldIds().contains(newDefaultRankFieldId)) {
            this.mapper.mapFieldId(oldDefaultRankFieldId, newDefaultRankFieldId);
            log.info("Mapping old default rank field [{}] to field [{}]", (Object)oldDefaultRankFieldId, (Object)newDefaultRankFieldId);
        }
    }

    public void setBackupProject(BackupProject backupProject) {
        this.backupProject = backupProject;
    }

    public void setBackupSystemInformation(BackupSystemInformation backupSystemInformation) {
    }

    public void setProjectImportMapper(ProjectImportMapper projectImportMapper) {
        this.mapper = (LexorankImportMapper)projectImportMapper.getNamedIdMapper("com.atlassian.greenhopper.imports.LexorankImportMapper");
        this.handledRankFields = new HashSet<Long>();
        this.unmatchedRankFields = new HashSet<Long>();
    }

    public void setProjectImportResults(ProjectImportResults projectImportResults) {
    }
}

