/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.imports;

import com.atlassian.greenhopper.imports.LexorankImportMapper;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.PluggableImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class LexorankOfbizImportHandler
implements PluggableImportOfBizEntityHandler {
    private static final String LEXORANK_KEY = "GreenHopper.LexoRank.Default.customfield.id";
    private static final String OSPROPERTY_NUMBER = "OSPropertyNumber";
    private static final String OSPROPERTY_ENTRY = "OSPropertyEntry";
    private static final Set HANDLED_ENTITIES = Sets.newHashSet((Object[])new String[]{"OSPropertyEntry", "OSPropertyNumber"});
    private LexorankImportMapper mapper;
    private String defaultRankFieldId = null;

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if (entityName.equals(OSPROPERTY_ENTRY)) {
            if (LEXORANK_KEY.equals(attributes.get("propertyKey"))) {
                this.defaultRankFieldId = attributes.get("id");
            }
        } else if (entityName.equals(OSPROPERTY_NUMBER) && this.defaultRankFieldId != null && this.defaultRankFieldId.equals(attributes.get("id"))) {
            this.mapper.registerOldDefaultRankFieldId(Long.valueOf(attributes.get("value")));
            this.mapper = null;
            this.defaultRankFieldId = null;
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean handlesEntity(String entityName) {
        return HANDLED_ENTITIES.contains(entityName);
    }

    public void setBackupProject(BackupProject backupProject) {
    }

    public void setBackupSystemInformation(BackupSystemInformation backupSystemInformation) {
    }

    public void setProjectImportMapper(ProjectImportMapper projectImportMapper) {
        this.mapper = new LexorankImportMapper();
        projectImportMapper.putNamedIdMapper("com.atlassian.greenhopper.imports.LexorankImportMapper", (ProjectImportIdMapper)this.mapper);
    }

    public void setProjectImportResults(ProjectImportResults projectImportResults) {
    }
}

