/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.imports;

import com.atlassian.greenhopper.imports.LexorankBean;
import com.atlassian.greenhopper.imports.LexorankImportMapper;
import com.atlassian.greenhopper.imports.ProjectImportService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ao.handler.PluggableImportAoEntityHandler;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LexorankImportHandler
implements PluggableImportAoEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(PluggableImportAoEntityHandler.class);
    private final ProjectImportService projectImportService;
    private SimpleProjectImportIdMapper issueIdMapper;
    private LexorankImportMapper mapper;

    @Autowired
    public LexorankImportHandler(ProjectImportService projectImportService) {
        this.projectImportService = projectImportService;
    }

    public void handleEntity(String aoTableName, Map<String, Object> map) throws ParseException, AbortImportException {
    }

    public boolean handlesEntity(String s) {
        return "AO_60DB71_LEXORANK".equals(s);
    }

    public Long getEntityWeight(String s) {
        return "AO_60DB71_LEXORANK".equals(s) ? 10002L : PluggableImportAoEntityHandler.WEIGHT_NONE;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void endTable(String s) {
        List<Long> rankFields = this.projectImportService.getRankFieldIds();
        List<Long> unmappedRankFieldIds = this.getUnmappedRankFieldIds(rankFields);
        Set<LexorankBean> sortedData = this.mapLexorankBeans(unmappedRankFieldIds);
        LexorankBean previousLexoRank = null;
        int batch = 1000;
        int i = 0;
        int importedCount = 0;
        int errorCount = 0;
        for (LexorankBean lexoRank : sortedData) {
            Long previousIssueId = null;
            if (previousLexoRank != null && previousLexoRank.getFieldId().equals(lexoRank.getFieldId())) {
                previousIssueId = previousLexoRank.getIssueId();
            }
            ServiceOutcome<Void> outcome = this.projectImportService.rankAfter(lexoRank.getFieldId(), lexoRank.getIssueId(), previousIssueId);
            ++importedCount;
            if (!outcome.isValid()) {
                log.error(outcome.toString());
                ++errorCount;
            }
            if (++i == 1000) {
                i = 0;
                log.info("Generated {} out of {} ranks ({} errors)", new Object[]{importedCount, sortedData.size(), errorCount});
            }
            previousLexoRank = lexoRank;
        }
        log.info("Generated {} out of {} ranks ({} errors)", new Object[]{importedCount, sortedData.size(), errorCount});
        this.mapper.clear();
        this.mapper = null;
        this.issueIdMapper = null;
    }

    private List<Long> getUnmappedRankFieldIds(List<Long> rankFieldIds) {
        ArrayList<Long> unmappedRankFieldIds = new ArrayList<Long>();
        Set<Long> mappedRankFieldIds = this.mapper.getNewFieldIds();
        for (Long rankFieldId : rankFieldIds) {
            if (mappedRankFieldIds.contains(rankFieldId)) continue;
            unmappedRankFieldIds.add(rankFieldId);
        }
        if (!unmappedRankFieldIds.isEmpty()) {
            log.info("No rank data exists for fields {}, default ranks will be used", unmappedRankFieldIds);
        }
        return unmappedRankFieldIds;
    }

    private Set<LexorankBean> mapLexorankBeans(List<Long> unmappedRankFieldIds) {
        TreeSet<LexorankBean> sortedData = new TreeSet<LexorankBean>();
        for (LexorankBean oldRankBean : this.mapper.getOldRankEntries()) {
            String mappedId = this.issueIdMapper.getMappedId(oldRankBean.getIssueId().toString());
            if (mappedId != null) {
                Long newIssueId = Long.valueOf(mappedId);
                Long newFieldId = this.mapper.getNewFieldId(oldRankBean.getFieldId());
                if (newFieldId != null) {
                    sortedData.add(new LexorankBean(newFieldId, newIssueId, oldRankBean.getRank()));
                }
                if (!oldRankBean.getFieldId().equals(this.mapper.getOldDefaultRankFieldId())) continue;
                for (Long unmappedRankFieldId : unmappedRankFieldIds) {
                    sortedData.add(new LexorankBean(unmappedRankFieldId, newIssueId, oldRankBean.getRank()));
                }
                continue;
            }
            log.debug("No mapping found for issue [{}], any rank values for this issue will not be imported", (Object)oldRankBean.getIssueId());
        }
        return sortedData;
    }

    public void setBackupProject(BackupProject backupProject) {
    }

    public void setBackupSystemInformation(BackupSystemInformation backupSystemInformation) {
    }

    public void setProjectImportMapper(ProjectImportMapper projectImportMapper) {
        this.issueIdMapper = projectImportMapper.getIssueMapper();
        this.mapper = (LexorankImportMapper)projectImportMapper.getNamedIdMapper("com.atlassian.greenhopper.imports.LexorankImportMapper");
    }

    public void setProjectImportResults(ProjectImportResults projectImportResults) {
    }
}

