/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.healthcheck;

import com.atlassian.greenhopper.healthcheck.AbstractHealthCheck;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.healthcheck.core.HealthStatus;

public class UpgradeTaskCheck
extends AbstractHealthCheck {
    private static final String NAME = "JIRA Agile Upgrade Tasks";
    private static final String DESCRIPTION = "Checks if JIRA Agile has successfully run it's upgrade tasks";
    private UpgradeVersionService upgradeVersionService;

    public UpgradeTaskCheck(UpgradeVersionService upgradeVersionService) {
        this.upgradeVersionService = upgradeVersionService;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    public HealthStatus check() {
        if (this.upgradeVersionService.versionLooksKosher()) {
            return this.createHealthStatus(true, "Upgrade successfully completed");
        }
        UpgradeVersionService.PluginRunInfo pluginInfo = this.upgradeVersionService.getCurrentPluginRunInfo();
        if (pluginInfo.isDowngrade()) {
            return this.createHealthStatus(false, "Plugin has been downgraded");
        }
        return this.createHealthStatus(false, "Upgrade failed or has not yet completed");
    }
}

