/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.healthcheck;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.healthcheck.AbstractHealthCheck;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityCheckReport;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityChecker;
import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.DefaultHealthStatus;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class LexoRankHealthCheck
extends AbstractHealthCheck {
    private static final String NAME = "JIRA Agile Ranking";
    private static final String DESCRIPTION = "Checks JIRA Agile's issue ranking system";
    private final LexoRankCustomFieldService lexoRankCustomFieldService;
    private final LexoRankIntegrityChecker lexoRankIntegrityChecker;

    public LexoRankHealthCheck(LexoRankCustomFieldService lexoRankCustomFieldService, LexoRankIntegrityChecker lexoRankIntegrityChecker) {
        this.lexoRankCustomFieldService = lexoRankCustomFieldService;
        this.lexoRankIntegrityChecker = lexoRankIntegrityChecker;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    public HealthStatus check() {
        Map<CustomField, Either<List<LexoRankIntegrityCheckReport.Result>, ErrorCollection>> reportableErrorsByRankField = this.getReportableErrorsByRankField();
        if (reportableErrorsByRankField.isEmpty()) {
            return new HealthStatus(this.getName(), this.getDescription(), Application.Plugin, true, "", System.currentTimeMillis(), null);
        }
        HealthCheckErrorCollection errorCollection = HealthCheckErrorCollection.fromMap(reportableErrorsByRankField);
        return new HealthStatus(this.getName(), this.getDescription(), Application.Plugin, false, "JIRA Agile Ranking health check failed with the following errors: " + errorCollection.toJson(), System.currentTimeMillis(), errorCollection);
    }

    private Map<CustomField, Either<List<LexoRankIntegrityCheckReport.Result>, ErrorCollection>> getReportableErrorsByRankField() {
        LinkedHashMap reportableErrorsByRankField = Maps.newLinkedHashMap();
        for (CustomField rankField : this.lexoRankCustomFieldService.getRankFields()) {
            Either reportableErrors;
            ServiceOutcome<LexoRankIntegrityCheckReport> integrityReportOutcome = this.lexoRankIntegrityChecker.performHealthChecks(rankField);
            if (integrityReportOutcome.isInvalid()) {
                reportableErrors = Either.right((Object)integrityReportOutcome.getErrors());
                reportableErrorsByRankField.put(rankField, reportableErrors);
                continue;
            }
            List<LexoRankIntegrityCheckReport.Result> fatalFailedResults = this.extractFatalFailedResults(integrityReportOutcome);
            if (fatalFailedResults.isEmpty()) continue;
            reportableErrors = Either.left(fatalFailedResults);
            reportableErrorsByRankField.put(rankField, reportableErrors);
        }
        return reportableErrorsByRankField;
    }

    private List<LexoRankIntegrityCheckReport.Result> extractFatalFailedResults(ServiceOutcome<LexoRankIntegrityCheckReport> integrityReportOutcome) {
        return Lists.newArrayList((Iterable)Iterables.filter(integrityReportOutcome.getValue().getResults(), result -> !result.passed && result.fatal));
    }

    static final class HealthStatus
    extends DefaultHealthStatus {
        private final HealthCheckErrorCollection errorCollection;

        private HealthStatus(String name, String description, Application application, boolean isHealthy, String failureReason, long time, HealthCheckErrorCollection errorCollection) {
            super(name, description, application, isHealthy, failureReason, time);
            this.errorCollection = errorCollection;
        }

        HealthCheckErrorCollection getErrorCollection() {
            return this.errorCollection;
        }
    }

    static enum HealthCheckErrorType {
        INTEGRITY_CHECK_RETURNED_INVALID_SERVICE_OUTCOME,
        FATAL_CHECK_FAILURE;

    }

    static final class HealthCheckError {
        private final long rankFieldId;
        private final HealthCheckErrorType errorType;
        private final Object details;

        private HealthCheckError(long rankFieldId, HealthCheckErrorType errorType, Object details) {
            this.rankFieldId = rankFieldId;
            this.errorType = errorType;
            this.details = details;
        }

        public long getRankFieldId() {
            return this.rankFieldId;
        }

        public HealthCheckErrorType getErrorType() {
            return this.errorType;
        }

        public Object getDetails() {
            return this.details;
        }
    }

    static final class HealthCheckErrorCollection {
        private final List<HealthCheckError> healthCheckErrors;

        private HealthCheckErrorCollection(List<HealthCheckError> healthCheckErrors) {
            this.healthCheckErrors = healthCheckErrors;
        }

        private static HealthCheckErrorCollection fromMap(Map<CustomField, Either<List<LexoRankIntegrityCheckReport.Result>, ErrorCollection>> reportableErrorsByRankField) {
            ArrayList healthCheckErrors = Lists.newArrayList();
            for (Map.Entry<CustomField, Either<List<LexoRankIntegrityCheckReport.Result>, ErrorCollection>> entry : reportableErrorsByRankField.entrySet()) {
                CustomField rankField = entry.getKey();
                Either<List<LexoRankIntegrityCheckReport.Result>, ErrorCollection> errors = entry.getValue();
                HealthCheckErrorType errorType = errors.isLeft() ? HealthCheckErrorType.FATAL_CHECK_FAILURE : HealthCheckErrorType.INTEGRITY_CHECK_RETURNED_INVALID_SERVICE_OUTCOME;
                Object details = errors.isLeft() ? errors.left().get() : errors.right().get();
                HealthCheckError error = new HealthCheckError(rankField.getIdAsLong(), errorType, details);
                healthCheckErrors.add(error);
            }
            return new HealthCheckErrorCollection(healthCheckErrors);
        }

        public List<HealthCheckError> getHealthCheckErrors() {
            return this.healthCheckErrors;
        }

        private String toJson() {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString((Object)this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

