/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.global;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.greenhopper.global.LoggerWrapper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PerformanceLogger
implements AutoCloseable {
    public static final String LOG_NAME = "com.atlassian.greenhopper.performance";
    public static final LoggerWrapper log = LoggerWrapper.with("com.atlassian.greenhopper.performance");

    public static PerformanceLogger debug(String message, Object ... params) {
        return PerformanceLogger.debug(Threshold.ANY, message, params);
    }

    public static PerformanceLogger info(String message, Object ... params) {
        return PerformanceLogger.info(Threshold.ANY, message, params);
    }

    public static PerformanceLogger debug(Threshold threshold, String message, Object ... params) {
        Objects.requireNonNull(message);
        if (log.isDebugEnabled()) {
            return new DefaultPerformanceLogger(threshold, Logger.Level.DEBUG, message, params);
        }
        return new EmptyPerformanceLogger();
    }

    public static PerformanceLogger info(Threshold threshold, String message, Object ... params) {
        Objects.requireNonNull(message);
        if (log.isInfoEnabled()) {
            return new DefaultPerformanceLogger(threshold, Logger.Level.INFO, message, params);
        }
        return new EmptyPerformanceLogger();
    }

    public abstract void measure(Runnable var1);

    public abstract void log();

    @Override
    public abstract void close();

    static class PerformanceLoggerRow {
        long totalTime;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long counter;
        long last;

        PerformanceLoggerRow() {
        }

        public synchronized void add(long time) {
            this.totalTime += time;
            this.minTime = Math.min(this.minTime, time);
            this.maxTime = Math.max(this.maxTime, time);
            ++this.counter;
            this.last = time;
        }

        public String toString() {
            if (this.counter == 0L) {
                return "";
            }
            return String.format("{ \"minMs\": %d, \"avgMs\": %d, \"maxMs\": %d, \"cnt\": %d, \"currMs\": %d }", this.minTime, this.totalTime / this.counter, this.maxTime, this.counter, this.last);
        }
    }

    public static enum Threshold {
        ANY(0L),
        ABOVE100MS(100L);

        private final long timeMs;

        private Threshold(long timeMs) {
            this.timeMs = timeMs;
        }

        public boolean isMet(long timeMs) {
            return timeMs >= this.timeMs;
        }
    }

    private static class EmptyPerformanceLogger
    extends PerformanceLogger {
        private EmptyPerformanceLogger() {
        }

        @Override
        public void close() {
        }

        @Override
        public void measure(Runnable toBeMeasured) {
            if (toBeMeasured != null) {
                toBeMeasured.run();
            }
        }

        @Override
        public void log() {
        }
    }

    static class DefaultPerformanceLogger
    extends PerformanceLogger {
        private static final ConcurrentHashMap<String, PerformanceLoggerRow> perfMap = new ConcurrentHashMap();
        private final long startTime = System.currentTimeMillis();
        private final Threshold threshold;
        private final Logger.Level level;
        private final String message;
        private boolean logCalled;

        private DefaultPerformanceLogger(Threshold threshold, Logger.Level level, String message, Object[] params) {
            this.threshold = threshold;
            this.level = level;
            this.message = log.createMessage(message, params);
        }

        @Override
        public void measure(Runnable toBeMeasured) {
            toBeMeasured.run();
            this.close();
        }

        @Override
        public synchronized void log() {
            if (this.logCalled) {
                throw new IllegalStateException("Only one call to close/log is allowed.");
            }
            this.logCalled = true;
            perfMap.putIfAbsent(this.message, new PerformanceLoggerRow());
            PerformanceLoggerRow row = perfMap.get(this.message);
            long totalTime = System.currentTimeMillis() - this.startTime;
            row.add(totalTime);
            if (!this.threshold.isMet(totalTime)) {
                return;
            }
            if (this.level == Logger.Level.DEBUG) {
                log.debug(String.format(this.message + " " + row.toString(), new Object[0]), new Object[0]);
            } else if (this.level == Logger.Level.INFO) {
                log.info(String.format(this.message + " " + row.toString(), new Object[0]), new Object[0]);
            }
        }

        @Override
        public void close() {
            this.log();
        }
    }
}

