/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.global;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerWrapper {
    private final Logger logger;

    LoggerWrapper(Logger logger) {
        this.logger = logger;
    }

    public static LoggerWrapper with(Logger logger) {
        return new LoggerWrapper(logger);
    }

    public static LoggerWrapper with(Class clazz) {
        return LoggerWrapper.with(LoggerFactory.getLogger((Class)clazz));
    }

    public static LoggerWrapper with(String name) {
        return LoggerWrapper.with(LoggerFactory.getLogger((String)name));
    }

    public String getName() {
        return this.logger.getName();
    }

    public LogLevel getLogLevel() {
        Level level = org.apache.log4j.Logger.getLogger((String)this.logger.getName()).getLevel();
        if (level != null) {
            if (level.equals((Object)Level.ERROR)) {
                return LogLevel.ERROR;
            }
            if (level.equals((Object)Level.DEBUG)) {
                return LogLevel.DEBUG;
            }
            if (level.equals((Object)Level.WARN)) {
                return LogLevel.WARN;
            }
            if (level.equals((Object)Level.INFO)) {
                return LogLevel.INFO;
            }
            if (level.equals((Object)Level.TRACE)) {
                return LogLevel.TRACE;
            }
        }
        return null;
    }

    public void setLogLevel(LogLevel logLevel) {
        Level level = null;
        if (logLevel != null) {
            switch (logLevel) {
                case ERROR: {
                    level = Level.ERROR;
                    break;
                }
                case DEBUG: {
                    level = Level.DEBUG;
                    break;
                }
                case WARN: {
                    level = Level.WARN;
                    break;
                }
                case INFO: {
                    level = Level.INFO;
                    break;
                }
                case TRACE: {
                    level = Level.TRACE;
                }
            }
        }
        org.apache.log4j.Logger.getLogger((String)this.logger.getName()).setLevel(level);
    }

    public void setInfoLogLevel() {
        this.setLogLevel(LogLevel.INFO);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void exception(Throwable t) {
        this.exception(t, LogLevel.ERROR);
    }

    public void exception(Throwable t, LogLevel logLevel) {
        try {
            switch (logLevel) {
                case ERROR: {
                    this.logger.error(t.getLocalizedMessage(), t);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(t.getLocalizedMessage(), t);
                    break;
                }
                case WARN: {
                    this.logger.warn(t.getLocalizedMessage(), t);
                    break;
                }
                case INFO: {
                    this.logger.info(t.getLocalizedMessage(), t);
                    break;
                }
                case TRACE: {
                    this.logger.trace(t.getLocalizedMessage(), t);
                }
            }
        }
        catch (Throwable t1) {
            t.printStackTrace();
            t1.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void error(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.createMessage(message, params), params);
        }
    }

    public void warn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.createMessage(message, params), params);
        }
    }

    public void info(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.createMessage(message, params), params);
        }
    }

    public void debug(String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.createMessage(message, params), params);
        }
    }

    public void trace(String message, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.createMessage(message, params), params);
        }
    }

    public String createMessage(String message, Object[] params) {
        try {
            return String.format(message, params);
        }
        catch (RuntimeException e) {
            this.logger.error("Unable to format message: " + message, (Throwable)e);
            return "";
        }
    }

    public void error(ErrorCollection errorCollection) {
        for (ErrorCollection.ErrorItem item : errorCollection.getErrors()) {
            this.error(item.getMessageKey(), item.getParams());
        }
    }

    public void warn(ErrorCollection errorCollection) {
        for (ErrorCollection.ErrorItem item : errorCollection.getErrors()) {
            this.warn(item.getMessageKey(), item.getParams());
        }
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        DEBUG,
        INFO,
        TRACE;

    }
}

