/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.gadget;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/gadgets/sprints")
@AnonymousAllowed
@Produces(value={"application/json"})
public class SprintRemainingDaysResource
extends AbstractResource {
    private RapidViewService rapidViewService;
    private SprintTimeRemainingService sprintTimeRemainingService;

    public SprintRemainingDaysResource(RapidViewService rapidViewService, SprintTimeRemainingService sprintTimeRemainingService) {
        this.rapidViewService = rapidViewService;
        this.sprintTimeRemainingService = sprintTimeRemainingService;
    }

    @GET
    @Path(value="/remainingdays")
    public Response getRemainingDays(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintRemainingDaysResource.this.getUser();
                RapidView rapidView = SprintRemainingDaysResource.this.check(SprintRemainingDaysResource.this.rapidViewService.getRapidView(user, rapidViewId));
                SprintTimeRemaining sprintTimeRemaining = SprintRemainingDaysResource.this.check(SprintRemainingDaysResource.this.sprintTimeRemainingService.getSprintTimeRemaining(user, rapidView, sprintId));
                SprintRemainingDaysResponse response = new SprintRemainingDaysResponse();
                response.days = sprintTimeRemaining.days;
                return Response.ok((Object)response).build();
            }
        });
    }

    @XmlRootElement
    public static class SprintRemainingDaysResponse
    extends RestTemplate {
        @XmlElement
        public int days;
    }
}

