/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.gadget;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.health.SprintHealth;
import com.atlassian.greenhopper.service.sprint.health.SprintHealthService;
import com.atlassian.greenhopper.service.sprint.health.SprintIssueMetrics;
import com.atlassian.greenhopper.service.sprint.health.SprintMetrics;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/gadgets/sprints/health")
@AnonymousAllowed
@Produces(value={"application/json"})
public class SprintHealthResource
extends AbstractResource {
    private RapidViewService rapidViewService;
    private SprintManager sprintManager;
    private SprintHealthService sprintMetricsService;
    private I18nFactoryService i18nFactoryService;

    public SprintHealthResource(RapidViewService rapidViewService, SprintManager sprintManager, SprintHealthService sprintMetricsService, I18nFactoryService i18nFactoryService) {
        this.rapidViewService = rapidViewService;
        this.sprintManager = sprintManager;
        this.sprintMetricsService = sprintMetricsService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @GET
    public Response getSprintHealth(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = SprintHealthResource.this.getUser();
                RapidView rapidView = SprintHealthResource.this.check(SprintHealthResource.this.rapidViewService.getRapidView(user, rapidViewId));
                Sprint sprint = SprintHealthResource.this.check(SprintHealthResource.this.sprintManager.getSprint(sprintId));
                SprintHealth sprintProgress = SprintHealthResource.this.check(SprintHealthResource.this.sprintMetricsService.getSprintHealth(user, rapidView, sprint));
                SprintHealthModel model = SprintHealthResource.this.toModel(user, sprintProgress);
                return Response.ok((Object)model).build();
            }
        });
    }

    private SprintHealthModel toModel(ApplicationUser user, SprintHealth sprintHealth) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        SprintHealthModel healthModel = new SprintHealthModel();
        healthModel.name = sprintHealth.name;
        healthModel.id = sprintHealth.id;
        PriorityModel highestPriority = new PriorityModel();
        highestPriority.id = sprintHealth.highestPriorityId;
        highestPriority.name = sprintHealth.highestPriorityName;
        healthModel.highestPriority = highestPriority;
        healthModel.flaggedField = sprintHealth.flaggedField;
        healthModel.timeBasedEstimation = sprintHealth.timeBasedEstimation;
        healthModel.timeTrackingEnabled = sprintHealth.timeTrackingEnabled;
        healthModel.status = new SprintStatusModel();
        healthModel.status.rating = sprintHealth.status.getRating();
        healthModel.status.name = i18n.getText(sprintHealth.status.getKey());
        for (SprintHealth.SprintHealthAssignee assigneeInfo : sprintHealth.assignees) {
            healthModel.assignees.add(new AssigneeModel(assigneeInfo.displayName, assigneeInfo.avatarURL, assigneeInfo.username));
        }
        boolean noEstimateValues = true;
        SprintProgressModel progressModel = new SprintProgressModel();
        for (Map.Entry<String, Double> entry : sprintHealth.progress.getEstimateByColumn().entrySet()) {
            ColumnModel columnModel = new ColumnModel();
            columnModel.name = i18n.getText(entry.getKey());
            columnModel.value = entry.getValue();
            if (columnModel.value != 0.0) {
                noEstimateValues = false;
            }
            progressModel.columns.add(columnModel);
        }
        healthModel.progress = progressModel;
        healthModel.noEstimateValues = noEstimateValues;
        for (Map.Entry<Object, Number> entry : sprintHealth.issueMetrics.getMetrics().entrySet()) {
            SprintIssueMetricModel issueMetricModel = new SprintIssueMetricModel();
            issueMetricModel.key = ((SprintIssueMetrics.Type)((Object)entry.getKey())).name().toLowerCase();
            issueMetricModel.value = (Integer)entry.getValue();
            healthModel.issueMetrics.add(issueMetricModel);
        }
        for (Map.Entry<Object, Object> entry : sprintHealth.sprintMetrics.getMetrics().entrySet()) {
            SprintMetricModel sprintMetricModel = new SprintMetricModel();
            sprintMetricModel.key = ((SprintMetrics.Type)((Object)entry.getKey())).name().toLowerCase();
            sprintMetricModel.value = (String)entry.getValue();
            healthModel.sprintMetrics.add(sprintMetricModel);
        }
        healthModel.timeRemaining = new SprintTimeRemainingModel();
        healthModel.timeRemaining.days = sprintHealth.timeRemaining.days;
        StatusMapModel statusMapModel = new StatusMapModel();
        for (Status status : sprintHealth.columns.getNotStarted()) {
            statusMapModel.notStarted.add(status.getName());
        }
        for (Status status : sprintHealth.columns.getInProgress()) {
            statusMapModel.inProgress.add(status.getName());
        }
        for (Status status : sprintHealth.columns.getDone()) {
            statusMapModel.done.add(status.getName());
        }
        healthModel.statusMap = statusMapModel;
        return healthModel;
    }

    @XmlRootElement
    private static class AssigneeModel {
        @XmlElement
        public String name;
        @XmlElement
        public String username;
        @XmlElement
        public String avatarUrl;

        public AssigneeModel(String name, String avatarUrl, String username) {
            this.name = name;
            this.avatarUrl = avatarUrl;
            this.username = username;
        }
    }

    @XmlRootElement
    private static class StatusMapModel {
        @XmlElement
        public List<String> notStarted = Lists.newArrayList();
        @XmlElement
        public List<String> inProgress = Lists.newArrayList();
        @XmlElement
        public List<String> done = Lists.newArrayList();

        private StatusMapModel() {
        }
    }

    @XmlRootElement
    private static class SprintTimeRemainingModel {
        @XmlElement
        public Integer days;

        private SprintTimeRemainingModel() {
        }
    }

    @XmlRootElement
    private static class SprintMetricModel {
        @XmlElement
        public String key;
        @XmlElement
        public String value;

        private SprintMetricModel() {
        }
    }

    @XmlRootElement
    private static class SprintIssueMetricModel {
        @XmlElement
        public String key;
        @XmlElement
        public Integer value;

        private SprintIssueMetricModel() {
        }
    }

    @XmlRootElement
    public static class ColumnModel {
        @XmlElement
        public String name;
        @XmlElement
        public Double value;
    }

    @XmlRootElement
    private static class SprintStatusModel {
        @XmlElement
        public String name;
        @XmlElement
        public Integer rating;

        private SprintStatusModel() {
        }
    }

    @XmlRootElement
    private static class SprintProgressModel {
        @XmlElement
        public List<ColumnModel> columns = Lists.newArrayList();

        private SprintProgressModel() {
        }
    }

    @XmlRootElement
    private static class PriorityModel {
        @XmlElement
        public String id;
        @XmlElement
        public String name;

        private PriorityModel() {
        }
    }

    @XmlRootElement
    private static class SprintHealthModel {
        @XmlElement
        public String name;
        @XmlElement
        public Long id;
        @XmlElement
        public SprintStatusModel status;
        @XmlElement
        public List<AssigneeModel> assignees = Lists.newArrayList();
        @XmlElement
        public SprintTimeRemainingModel timeRemaining;
        @XmlElement
        public SprintProgressModel progress;
        @XmlElement
        public List<SprintIssueMetricModel> issueMetrics = Lists.newArrayList();
        @XmlElement
        public List<SprintMetricModel> sprintMetrics = Lists.newArrayList();
        @XmlElement
        public boolean timeBasedEstimation;
        @XmlElement
        public boolean timeTrackingEnabled;
        @XmlElement
        public boolean noEstimateValues;
        @XmlElement
        public PriorityModel highestPriority;
        @XmlElement
        public String flaggedField;
        @XmlElement
        public StatusMapModel statusMap;

        private SprintHealthModel() {
        }
    }
}

