/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.gadget;

import com.atlassian.greenhopper.gadget.AbstractGadgetResource;
import com.atlassian.greenhopper.gadget.RapidGadgetHelper;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterEntry;
import com.atlassian.greenhopper.web.rapid.view.QuickFilterHelper;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/gadgets/rapidview/pool")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RapidViewGadgetResource
extends AbstractGadgetResource {
    private RapidGadgetHelper helper;
    private QuickFilterHelper quickFilterHelper;
    private UserUtil userUtil;
    private QuickFilterService quickFilterService;
    private static final String RAPID_BOARD_ID = "rapidViewId";

    public RapidViewGadgetResource(RapidGadgetHelper helper, QuickFilterHelper quickFilterHelper, UserUtil userUtil, QuickFilterService quickFilterService) {
        this.helper = helper;
        this.quickFilterHelper = quickFilterHelper;
        this.userUtil = userUtil;
        this.quickFilterService = quickFilterService;
    }

    public RapidViewGadgetResource(RapidGadgetHelper validator) {
        this.helper = validator;
    }

    @GET
    @Path(value="/validate")
    public Response validate(@Context HttpServletRequest request, final @QueryParam(value="rapidViewId") Long rapidBoardId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                RapidViewGadgetResource.this.helper.validateRapidViewId(errors, rapidBoardId);
                return RapidViewGadgetResource.this.createValidationResponse(errors);
            }
        });
    }

    @GET
    @Path(value="/quickfilters/{rapidViewId}")
    public Response getQuickFilters(final @Context HttpServletRequest request, final @PathParam(value="rapidViewId") Long rapidBoardId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                RapidView rapidView = RapidViewGadgetResource.this.helper.validateRapidViewId(errors, rapidBoardId);
                if (errors.isEmpty()) {
                    LinkedList<QuickFilterEntry> filters = new LinkedList<QuickFilterEntry>();
                    for (QuickFilter quickFilter : RapidViewGadgetResource.this.quickFilterService.loadQuickFilters(rapidView)) {
                        filters.add(RapidViewGadgetResource.this.quickFilterHelper.getQuickFilter(RapidViewGadgetResource.this.userUtil.getUserByName(request.getRemoteUser()), rapidBoardId, quickFilter.getId()));
                    }
                    return RapidViewGadgetResource.this.createOkResponse(filters);
                }
                return RapidViewGadgetResource.this.createErrorResponse(errors);
            }
        });
    }
}

