/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.gadget;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidGadgetHelper {
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private RapidViewService rapidViewService;

    public RapidView validateRapidViewId(Collection<ValidationError> validationErrors, Long rapidViewId) {
        ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(this.authenticationContext.getUser(), rapidViewId);
        if (!rapidView.isValid()) {
            this.addErrorsToGadgetValidationErrors(rapidView.getErrors(), validationErrors, "rapidBoardId");
        }
        return rapidView.getValue();
    }

    private void addErrorsToGadgetValidationErrors(ErrorCollection errorCollection, Collection<ValidationError> validationErrors, String fieldName) {
        for (ErrorCollection.ErrorItem item : errorCollection.getErrors()) {
            ArrayList<String> params = new ArrayList<String>();
            if (item.getParams() != null) {
                for (Object o : item.getParams()) {
                    params.add(String.valueOf(o));
                }
            }
            validationErrors.add(new ValidationError(fieldName, item.getMessageKey(), params));
        }
    }
}

