/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.features;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagDefinitions;
import com.atlassian.jira.config.FeatureFlagProvider;
import java.text.MessageFormat;
import java.util.Set;

public class SoftwareFeatureFlags
implements FeatureFlagProvider {
    private static final FeatureFlagDefinitions FEATURE_FLAG_DEFINITIONS = new FeatureFlagDefinitions();
    public static final FeatureFlag KANPLAN = SoftwareFeatureFlags.agileFeatureFlag("kanplan");
    public static final FeatureFlag KANPLAN_EPICS_AND_VERSIONS = SoftwareFeatureFlags.agileFeatureFlag("kanplan.epics.and.versions");
    public static final FeatureFlag SPRINT_GOAL = SoftwareFeatureFlags.agileFeatureFlag("sprint.goal");
    public static final FeatureFlag CLOSED_SPRINT_EDIT_DELETE = SoftwareFeatureFlags.agileFeatureFlag("edit.closed.sprint");
    public static final FeatureFlag OPTIMISTIC_TRANSITION = SoftwareFeatureFlags.agileFeatureFlag("optimistic.transitions");
    public static final FeatureFlag KANBAN_HIDE_OLD_DONE_ISSUES = SoftwareFeatureFlags.agileFeatureFlagOnByDefault("kanban.hide.old.done.issues");
    public static final FeatureFlag BACKLOG_SHOW_MORE = SoftwareFeatureFlags.agileFeatureFlag("backlog.showmore");
    public static final FeatureFlag RAPID_BOARD_BANDS = SoftwareFeatureFlags.agileFeatureFlagOnByDefault("rapid.boards.bands");
    public static final FeatureFlag DATA_ON_PAGE_LOAD = SoftwareFeatureFlags.agileFeatureFlagOnByDefault("dataonpageload");
    public static final FeatureFlag FLEXIBLE_BOARDS = SoftwareFeatureFlags.agileFeatureFlag("flexible.boards");
    public static final FeatureFlag SPRINT_PICKER_ALLSPRINTS_SUGGESTION = SoftwareFeatureFlags.agileFeatureFlagOnByDefault("sprint.picker.allsprints.suggestion");

    private static FeatureFlag agileFeatureFlag(String key) {
        return SoftwareFeatureFlags.agileFeatureFlagDefinition(key).offByDefault().define();
    }

    private static FeatureFlag agileFeatureFlagOnByDefault(String key) {
        return SoftwareFeatureFlags.agileFeatureFlagDefinition(key).onByDefault().define();
    }

    private static FeatureFlagDefinitions.Definition agileFeatureFlagDefinition(String key) {
        return FEATURE_FLAG_DEFINITIONS.featureFlag(MessageFormat.format("{0}.{1}", "com.atlassian.jira.agile.darkfeature", key));
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return FEATURE_FLAG_DEFINITIONS.getFeatureFlags();
    }
}

