/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.features;

public enum JiraSoftwareFeature {
    PARALLEL_SPRINTS("gh.configuration.parallel.sprints"),
    STICKY_SPRINT_HEADERS("gh.configuration.sticky.sprint.headers", true),
    DAYS_IN_COLUMN("gh.configuration.days.in.column", true);

    private final String propertyKey;
    private final boolean enabledByDefault;

    private JiraSoftwareFeature(String propertyKey) {
        this.propertyKey = propertyKey;
        this.enabledByDefault = false;
    }

    private JiraSoftwareFeature(String propertyKey, boolean enabledByDefault) {
        this.propertyKey = propertyKey;
        this.enabledByDefault = enabledByDefault;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public static JiraSoftwareFeature valueFor(String name) {
        try {
            if (name == null) {
                return null;
            }
            return JiraSoftwareFeature.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

