/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.features;

import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.feature.FeatureFlagActivator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JiraSoftwareBuildNumberFeatureFlagActivator
implements FeatureFlagActivator {
    private final BuildUtilsInfo buildUtilsInfo;
    public static final ImmutableMap<FeatureFlag, Integer> BUILD_NUMBER_ACTIVATED_FEATURE_FLAGS = ImmutableMap.builder().put((Object)SoftwareFeatureFlags.OPTIMISTIC_TRANSITION, (Object)76000).put((Object)SoftwareFeatureFlags.BACKLOG_SHOW_MORE, (Object)800000).put((Object)SoftwareFeatureFlags.FLEXIBLE_BOARDS, (Object)801000).build();

    @Autowired
    public JiraSoftwareBuildNumberFeatureFlagActivator(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public Set<FeatureFlag> getActivatedFlags() {
        int currentBuildNumber = this.buildUtilsInfo.getDatabaseBuildNumber();
        return BUILD_NUMBER_ACTIVATED_FEATURE_FLAGS.entrySet().stream().filter(entry -> currentBuildNumber >= (Integer)entry.getValue()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

