/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.events.sprint;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.api.events.sprint.SprintClosedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintCreatedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintDeletedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintStartedEvent;
import com.atlassian.greenhopper.api.events.sprint.SprintUpdatedEvent;
import com.atlassian.greenhopper.service.sprint.Sprint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintEventPublisher {
    @Autowired
    private EventPublisher eventPublisher;

    public void publishSprintDeleted(Sprint sprint) {
        this.eventPublisher.publish((Object)new SprintDeletedEvent(sprint));
    }

    public void publishUpdateEvents(Sprint existingSprint, Sprint newSprint) {
        if (this.isStartedChange(existingSprint, newSprint)) {
            this.eventPublisher.publish((Object)new SprintStartedEvent(newSprint));
        } else if (this.isClosedChange(existingSprint, newSprint)) {
            this.eventPublisher.publish((Object)new SprintClosedEvent(newSprint));
        }
        if (this.isOtherChange(existingSprint, newSprint)) {
            this.eventPublisher.publish((Object)new SprintUpdatedEvent(newSprint, existingSprint));
        }
    }

    private boolean isOtherChange(Sprint existingSprint, Sprint newSprint) {
        return !new EqualsBuilder().append((Object)existingSprint.getName(), (Object)newSprint.getName()).append((Object)existingSprint.getRapidViewId(), (Object)newSprint.getRapidViewId()).append((Object)existingSprint.getStartDate(), (Object)newSprint.getStartDate()).append((Object)existingSprint.getEndDate(), (Object)newSprint.getEndDate()).isEquals();
    }

    public void publishSprintCreated(Sprint newSprint) {
        this.eventPublisher.publish((Object)new SprintCreatedEvent(newSprint));
    }

    private boolean isStartedChange(Sprint previous, Sprint current) {
        return previous.isFuture() && current.isActive();
    }

    private boolean isClosedChange(Sprint previous, Sprint current) {
        return previous.isActive() && current.isClosed();
    }
}

