/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.events.board;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.api.events.board.BoardConfigurationChangedEvent;
import com.atlassian.greenhopper.api.events.board.BoardCreatedEvent;
import com.atlassian.greenhopper.api.events.board.BoardDeletedEvent;
import com.atlassian.greenhopper.api.events.board.BoardUpdatedEvent;
import com.atlassian.greenhopper.api.events.board.KanbanBacklogToggledEvent;
import com.atlassian.greenhopper.model.rapid.RapidView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardEventPublisher {
    private final EventPublisher eventPublisher;

    @Autowired
    public BoardEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void publishBoardCreated(RapidView newBoard) {
        this.eventPublisher.publish((Object)new BoardCreatedEvent(newBoard));
    }

    public void publishBoardDeleted(RapidView board) {
        this.eventPublisher.publish((Object)new BoardDeletedEvent(board));
    }

    public void publishBoardUpdatedEvent(RapidView board) {
        this.eventPublisher.publish((Object)new BoardUpdatedEvent(board));
    }

    public void publishBoardConfigurationChangedEvent(RapidView board) {
        this.eventPublisher.publish((Object)new BoardConfigurationChangedEvent(board));
    }

    public void publishKanbanBacklogToggledEvent(RapidView board, boolean newState) {
        this.eventPublisher.publish((Object)new KanbanBacklogToggledEvent(board, newState));
    }
}

