/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.entity.remotelink.sprint;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.confluence.ConfluenceGlobalIdFactory;
import com.atlassian.greenhopper.confluence.ConfluencePage;
import com.atlassian.greenhopper.confluence.rpc.ConfluenceRpcService;
import com.atlassian.greenhopper.confluence.rpc.ConfluenceRpcServiceImpl;
import com.atlassian.greenhopper.entity.remotelink.sprint.ConfluenceRemoteSprintLinkDecoratorService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluenceGlobalId;
import com.atlassian.jira.util.BaseUrlSwapper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfluenceCopiedRemoteSprintLinkDecoratorServiceImpl
implements ConfluenceRemoteSprintLinkDecoratorService {
    private static final String FAVICON_PATH = "/images/icons/favicon.png";
    private ConfluenceRpcService confluenceRpcService = new ConfluenceRpcServiceImpl();
    private ConfluenceGlobalIdFactory confluenceGlobalIdFactory;

    @Autowired
    public ConfluenceCopiedRemoteSprintLinkDecoratorServiceImpl(ApplicationLinkService applicationLinkService) {
        this.confluenceGlobalIdFactory = new ConfluenceGlobalIdFactory(applicationLinkService);
    }

    @Override
    public RemoteSprintLink decorate(RemoteSprintLink remoteSprintLink) throws CredentialsRequiredException, IOException, PermissionException {
        if (!RemoteSprintLink.ApplicationType.CONFLUENCE.equals((Object)remoteSprintLink.getApplicationType())) {
            throw new IllegalArgumentException("Remote link is not to Confluence");
        }
        ConfluenceGlobalId globalId = this.getGlobalId(remoteSprintLink);
        try {
            RemoteResponse<ConfluencePage> response = this.confluenceRpcService.getPage(globalId.getApplicationLink(), globalId.getPageId());
            return ConfluenceCopiedRemoteSprintLinkDecoratorServiceImpl.handleResponse(response, remoteSprintLink, globalId.getApplicationLink());
        }
        catch (ResponseException e) {
            throw new IOException("Failed to load Confluence Page from remote server", e);
        }
    }

    @Override
    public ConfluenceGlobalId getGlobalId(RemoteSprintLink remoteSprintLink) {
        RemoteIssueLinkBuilder builder = new RemoteIssueLinkBuilder();
        RemoteIssueLink remoteIssueLink = builder.globalId(remoteSprintLink.getGlobalId()).url(remoteSprintLink.getUrl()).build();
        return this.confluenceGlobalIdFactory.create(remoteIssueLink);
    }

    private static RemoteSprintLink handleResponse(RemoteResponse<ConfluencePage> response, RemoteSprintLink remoteSprintLink, ApplicationLink appLink) throws ResponseException, CredentialsRequiredException, PermissionException {
        if (!response.isSuccessful()) {
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatusCode());
            switch (status) {
                case UNAUTHORIZED: {
                    throw new CredentialsRequiredException((AuthorisationURIGenerator)appLink.createAuthenticatedRequestFactory(), "Token expired");
                }
                case FORBIDDEN: {
                    throw new ResponseException("Confluence remote API is disabled");
                }
            }
            ConfluenceCopiedRemoteSprintLinkDecoratorServiceImpl.checkErrorMessages(response);
            throw new ResponseException("Status Code: " + response.getStatusCode() + ", Status Text: " + response.getStatusText() + ", Errors: " + response.getErrors().getErrors() + ", Error Messages: " + response.getErrors().getErrorMessages());
        }
        String iconUrl = new UrlBuilder(appLink.getDisplayUrl().toASCIIString()).addPathUnsafe(FAVICON_PATH).asUrlString();
        ConfluencePage confluencePage = (ConfluencePage)response.getEntity();
        remoteSprintLink.setUrl(BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)confluencePage.getUrl(), (ApplicationLink)appLink));
        remoteSprintLink.setTitle(confluencePage.getTitle());
        remoteSprintLink.setApplicationName(appLink.getName());
        return remoteSprintLink;
    }

    private static void checkErrorMessages(RemoteResponse<?> response) throws PermissionException {
        if (response.containsErrorWithText(new String[]{"NotPermittedException"})) {
            throw new PermissionException();
        }
    }
}

